/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.AbstractOAuth2Configurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OidcClientRegistrationEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OidcProviderConfigurationEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OidcUserInfoEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContext;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.util.UriComponentsBuilder;

public final class OidcConfigurer
extends AbstractOAuth2Configurer {
    private final Map<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> configurers = new LinkedHashMap<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer>();
    private RequestMatcher requestMatcher;

    OidcConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
        this.addConfigurer(OidcProviderConfigurationEndpointConfigurer.class, new OidcProviderConfigurationEndpointConfigurer(objectPostProcessor));
        this.addConfigurer(OidcUserInfoEndpointConfigurer.class, new OidcUserInfoEndpointConfigurer(objectPostProcessor));
    }

    public OidcConfigurer providerConfigurationEndpoint(Customizer<OidcProviderConfigurationEndpointConfigurer> providerConfigurationEndpointCustomizer) {
        providerConfigurationEndpointCustomizer.customize((Object)this.getConfigurer(OidcProviderConfigurationEndpointConfigurer.class));
        return this;
    }

    public OidcConfigurer clientRegistrationEndpoint(Customizer<OidcClientRegistrationEndpointConfigurer> clientRegistrationEndpointCustomizer) {
        OidcClientRegistrationEndpointConfigurer clientRegistrationEndpointConfigurer = this.getConfigurer(OidcClientRegistrationEndpointConfigurer.class);
        if (clientRegistrationEndpointConfigurer == null) {
            this.addConfigurer(OidcClientRegistrationEndpointConfigurer.class, new OidcClientRegistrationEndpointConfigurer(this.getObjectPostProcessor()));
            clientRegistrationEndpointConfigurer = this.getConfigurer(OidcClientRegistrationEndpointConfigurer.class);
        }
        clientRegistrationEndpointCustomizer.customize((Object)clientRegistrationEndpointConfigurer);
        return this;
    }

    public OidcConfigurer userInfoEndpoint(Customizer<OidcUserInfoEndpointConfigurer> userInfoEndpointCustomizer) {
        userInfoEndpointCustomizer.customize((Object)this.getConfigurer(OidcUserInfoEndpointConfigurer.class));
        return this;
    }

    @Override
    void init(HttpSecurity httpSecurity) {
        ArrayList requestMatchers = new ArrayList();
        this.configurers.values().forEach(configurer -> {
            configurer.init(httpSecurity);
            requestMatchers.add(configurer.getRequestMatcher());
        });
        this.requestMatcher = new OrRequestMatcher(requestMatchers);
    }

    @Override
    void configure(HttpSecurity httpSecurity) {
        OidcClientRegistrationEndpointConfigurer clientRegistrationEndpointConfigurer = this.getConfigurer(OidcClientRegistrationEndpointConfigurer.class);
        if (clientRegistrationEndpointConfigurer != null) {
            OidcProviderConfigurationEndpointConfigurer providerConfigurationEndpointConfigurer = this.getConfigurer(OidcProviderConfigurationEndpointConfigurer.class);
            providerConfigurationEndpointConfigurer.addDefaultProviderConfigurationCustomizer(builder -> {
                AuthorizationServerContext authorizationServerContext = AuthorizationServerContextHolder.getContext();
                String issuer = authorizationServerContext.getIssuer();
                AuthorizationServerSettings authorizationServerSettings = authorizationServerContext.getAuthorizationServerSettings();
                String clientRegistrationEndpoint = UriComponentsBuilder.fromUriString((String)issuer).path(authorizationServerSettings.getOidcClientRegistrationEndpoint()).build().toUriString();
                builder.clientRegistrationEndpoint(clientRegistrationEndpoint);
            });
        }
        this.configurers.values().forEach(configurer -> configurer.configure(httpSecurity));
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    <T> T getConfigurer(Class<T> type) {
        return (T)this.configurers.get(type);
    }

    private <T extends AbstractOAuth2Configurer> void addConfigurer(Class<T> configurerType, T configurer) {
        this.configurers.put(configurerType, configurer);
    }
}

