/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationValidator;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationConsentAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.AbstractOAuth2Configurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2ConfigurerUtils;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.authentication.DelegatingAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationCodeRequestAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationConsentAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OAuth2AuthorizationEndpointConfigurer
extends AbstractOAuth2Configurer {
    private RequestMatcher requestMatcher;
    private final List<AuthenticationConverter> authorizationRequestConverters = new ArrayList<AuthenticationConverter>();
    private Consumer<List<AuthenticationConverter>> authorizationRequestConvertersConsumer = authorizationRequestConverters -> {};
    private final List<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
    private Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer = authenticationProviders -> {};
    private AuthenticationSuccessHandler authorizationResponseHandler;
    private AuthenticationFailureHandler errorResponseHandler;
    private String consentPage;
    private Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> authorizationCodeRequestAuthenticationValidator;

    OAuth2AuthorizationEndpointConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public OAuth2AuthorizationEndpointConfigurer authorizationRequestConverter(AuthenticationConverter authorizationRequestConverter) {
        Assert.notNull((Object)authorizationRequestConverter, (String)"authorizationRequestConverter cannot be null");
        this.authorizationRequestConverters.add(authorizationRequestConverter);
        return this;
    }

    public OAuth2AuthorizationEndpointConfigurer authorizationRequestConverters(Consumer<List<AuthenticationConverter>> authorizationRequestConvertersConsumer) {
        Assert.notNull(authorizationRequestConvertersConsumer, (String)"authorizationRequestConvertersConsumer cannot be null");
        this.authorizationRequestConvertersConsumer = authorizationRequestConvertersConsumer;
        return this;
    }

    public OAuth2AuthorizationEndpointConfigurer authenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"authenticationProvider cannot be null");
        this.authenticationProviders.add(authenticationProvider);
        return this;
    }

    public OAuth2AuthorizationEndpointConfigurer authenticationProviders(Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer) {
        Assert.notNull(authenticationProvidersConsumer, (String)"authenticationProvidersConsumer cannot be null");
        this.authenticationProvidersConsumer = authenticationProvidersConsumer;
        return this;
    }

    public OAuth2AuthorizationEndpointConfigurer authorizationResponseHandler(AuthenticationSuccessHandler authorizationResponseHandler) {
        this.authorizationResponseHandler = authorizationResponseHandler;
        return this;
    }

    public OAuth2AuthorizationEndpointConfigurer errorResponseHandler(AuthenticationFailureHandler errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    public OAuth2AuthorizationEndpointConfigurer consentPage(String consentPage) {
        this.consentPage = consentPage;
        return this;
    }

    void addAuthorizationCodeRequestAuthenticationValidator(Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> authenticationValidator) {
        this.authorizationCodeRequestAuthenticationValidator = this.authorizationCodeRequestAuthenticationValidator == null ? authenticationValidator : this.authorizationCodeRequestAuthenticationValidator.andThen(authenticationValidator);
    }

    @Override
    void init(HttpSecurity httpSecurity) {
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        this.requestMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(authorizationServerSettings.getAuthorizationEndpoint(), HttpMethod.GET.name()), new AntPathRequestMatcher(authorizationServerSettings.getAuthorizationEndpoint(), HttpMethod.POST.name())});
        List<AuthenticationProvider> authenticationProviders = this.createDefaultAuthenticationProviders(httpSecurity);
        if (!this.authenticationProviders.isEmpty()) {
            authenticationProviders.addAll(0, this.authenticationProviders);
        }
        this.authenticationProvidersConsumer.accept(authenticationProviders);
        authenticationProviders.forEach(authenticationProvider -> httpSecurity.authenticationProvider(this.postProcess(authenticationProvider)));
    }

    @Override
    void configure(HttpSecurity httpSecurity) {
        AuthenticationManager authenticationManager = (AuthenticationManager)httpSecurity.getSharedObject(AuthenticationManager.class);
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        OAuth2AuthorizationEndpointFilter authorizationEndpointFilter = new OAuth2AuthorizationEndpointFilter(authenticationManager, authorizationServerSettings.getAuthorizationEndpoint());
        List<AuthenticationConverter> authenticationConverters = OAuth2AuthorizationEndpointConfigurer.createDefaultAuthenticationConverters();
        if (!this.authorizationRequestConverters.isEmpty()) {
            authenticationConverters.addAll(0, this.authorizationRequestConverters);
        }
        this.authorizationRequestConvertersConsumer.accept(authenticationConverters);
        authorizationEndpointFilter.setAuthenticationConverter(new DelegatingAuthenticationConverter(authenticationConverters));
        if (this.authorizationResponseHandler != null) {
            authorizationEndpointFilter.setAuthenticationSuccessHandler(this.authorizationResponseHandler);
        }
        if (this.errorResponseHandler != null) {
            authorizationEndpointFilter.setAuthenticationFailureHandler(this.errorResponseHandler);
        }
        if (StringUtils.hasText((String)this.consentPage)) {
            authorizationEndpointFilter.setConsentPage(this.consentPage);
        }
        httpSecurity.addFilterBefore((Filter)this.postProcess(authorizationEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    private static List<AuthenticationConverter> createDefaultAuthenticationConverters() {
        ArrayList<AuthenticationConverter> authenticationConverters = new ArrayList<AuthenticationConverter>();
        authenticationConverters.add(new OAuth2AuthorizationCodeRequestAuthenticationConverter());
        authenticationConverters.add(new OAuth2AuthorizationConsentAuthenticationConverter());
        return authenticationConverters;
    }

    private List<AuthenticationProvider> createDefaultAuthenticationProviders(HttpSecurity httpSecurity) {
        ArrayList<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
        OAuth2AuthorizationCodeRequestAuthenticationProvider authorizationCodeRequestAuthenticationProvider = new OAuth2AuthorizationCodeRequestAuthenticationProvider(OAuth2ConfigurerUtils.getRegisteredClientRepository(httpSecurity), OAuth2ConfigurerUtils.getAuthorizationService(httpSecurity), OAuth2ConfigurerUtils.getAuthorizationConsentService(httpSecurity));
        if (this.authorizationCodeRequestAuthenticationValidator != null) {
            authorizationCodeRequestAuthenticationProvider.setAuthenticationValidator(new OAuth2AuthorizationCodeRequestAuthenticationValidator().andThen(this.authorizationCodeRequestAuthenticationValidator));
        }
        authenticationProviders.add(authorizationCodeRequestAuthenticationProvider);
        OAuth2AuthorizationConsentAuthenticationProvider authorizationConsentAuthenticationProvider = new OAuth2AuthorizationConsentAuthenticationProvider(OAuth2ConfigurerUtils.getRegisteredClientRepository(httpSecurity), OAuth2ConfigurerUtils.getAuthorizationService(httpSecurity), OAuth2ConfigurerUtils.getAuthorizationConsentService(httpSecurity));
        authenticationProviders.add(authorizationConsentAuthenticationProvider);
        return authenticationProviders;
    }
}

