/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.security.Principal;
import java.util.Base64;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeGenerator;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationValidator;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationConsentAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.token.DefaultOAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OAuth2AuthorizationCodeRequestAuthenticationProvider
implements AuthenticationProvider {
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.2.1";
    private static final String PKCE_ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc7636#section-4.4.1";
    private static final StringKeyGenerator DEFAULT_STATE_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder());
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;
    private final OAuth2AuthorizationConsentService authorizationConsentService;
    private OAuth2TokenGenerator<OAuth2AuthorizationCode> authorizationCodeGenerator = new OAuth2AuthorizationCodeGenerator();
    private Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> authenticationValidator = new OAuth2AuthorizationCodeRequestAuthenticationValidator();

    public OAuth2AuthorizationCodeRequestAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService, OAuth2AuthorizationConsentService authorizationConsentService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        Assert.notNull((Object)authorizationConsentService, (String)"authorizationConsentService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
        this.authorizationConsentService = authorizationConsentService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String redirectUri;
        OAuth2AuthorizationConsent currentAuthorizationConsent;
        Authentication principal;
        String codeChallenge;
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication;
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(authorizationCodeRequestAuthentication.getClientId());
        if (registeredClient == null) {
            OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_request", "client_id", authorizationCodeRequestAuthentication, null);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved registered client");
        }
        OAuth2AuthorizationCodeRequestAuthenticationContext authenticationContext = OAuth2AuthorizationCodeRequestAuthenticationContext.with(authorizationCodeRequestAuthentication).registeredClient(registeredClient).build();
        this.authenticationValidator.accept(authenticationContext);
        if (!registeredClient.getAuthorizationGrantTypes().contains(AuthorizationGrantType.AUTHORIZATION_CODE)) {
            OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("unauthorized_client", "client_id", authorizationCodeRequestAuthentication, registeredClient);
        }
        if (StringUtils.hasText((String)(codeChallenge = (String)authorizationCodeRequestAuthentication.getAdditionalParameters().get("code_challenge")))) {
            String codeChallengeMethod = (String)authorizationCodeRequestAuthentication.getAdditionalParameters().get("code_challenge_method");
            if (!StringUtils.hasText((String)codeChallengeMethod) || !"S256".equals(codeChallengeMethod)) {
                OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_request", "code_challenge_method", PKCE_ERROR_URI, authorizationCodeRequestAuthentication, registeredClient, null);
            }
        } else if (registeredClient.getClientSettings().isRequireProofKey()) {
            OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_request", "code_challenge", PKCE_ERROR_URI, authorizationCodeRequestAuthentication, registeredClient, null);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated authorization code request parameters");
        }
        if (!OAuth2AuthorizationCodeRequestAuthenticationProvider.isPrincipalAuthenticated(principal = (Authentication)authorizationCodeRequestAuthentication.getPrincipal())) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Did not authenticate authorization code request since principal not authenticated");
            }
            return authorizationCodeRequestAuthentication;
        }
        OAuth2AuthorizationRequest authorizationRequest = OAuth2AuthorizationRequest.authorizationCode().authorizationUri(authorizationCodeRequestAuthentication.getAuthorizationUri()).clientId(registeredClient.getClientId()).redirectUri(authorizationCodeRequestAuthentication.getRedirectUri()).scopes(authorizationCodeRequestAuthentication.getScopes()).state(authorizationCodeRequestAuthentication.getState()).additionalParameters(authorizationCodeRequestAuthentication.getAdditionalParameters()).build();
        if (OAuth2AuthorizationCodeRequestAuthenticationProvider.requireAuthorizationConsent(registeredClient, authorizationRequest, currentAuthorizationConsent = this.authorizationConsentService.findById(registeredClient.getId(), principal.getName()))) {
            Set<String> currentAuthorizedScopes;
            String state = DEFAULT_STATE_GENERATOR.generateKey();
            OAuth2Authorization authorization = OAuth2AuthorizationCodeRequestAuthenticationProvider.authorizationBuilder(registeredClient, principal, authorizationRequest).attribute("state", state).build();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Generated authorization consent state");
            }
            this.authorizationService.save(authorization);
            Set<String> set = currentAuthorizedScopes = currentAuthorizationConsent != null ? currentAuthorizationConsent.getScopes() : null;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Saved authorization");
            }
            return new OAuth2AuthorizationConsentAuthenticationToken(authorizationRequest.getAuthorizationUri(), registeredClient.getClientId(), principal, state, currentAuthorizedScopes, null);
        }
        OAuth2TokenContext tokenContext = OAuth2AuthorizationCodeRequestAuthenticationProvider.createAuthorizationCodeTokenContext(authorizationCodeRequestAuthentication, registeredClient, null, authorizationRequest.getScopes());
        OAuth2AuthorizationCode authorizationCode = this.authorizationCodeGenerator.generate(tokenContext);
        if (authorizationCode == null) {
            OAuth2Error error = new OAuth2Error("server_error", "The token generator failed to generate the authorization code.", ERROR_URI);
            throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, null);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Generated authorization code");
        }
        OAuth2Authorization authorization = OAuth2AuthorizationCodeRequestAuthenticationProvider.authorizationBuilder(registeredClient, principal, authorizationRequest).authorizedScopes(authorizationRequest.getScopes()).token(authorizationCode).build();
        this.authorizationService.save(authorization);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Saved authorization");
        }
        if (!StringUtils.hasText((String)(redirectUri = authorizationRequest.getRedirectUri()))) {
            redirectUri = registeredClient.getRedirectUris().iterator().next();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated authorization code request");
        }
        return new OAuth2AuthorizationCodeRequestAuthenticationToken(authorizationRequest.getAuthorizationUri(), registeredClient.getClientId(), principal, authorizationCode, redirectUri, authorizationRequest.getState(), authorizationRequest.getScopes());
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2AuthorizationCodeRequestAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setAuthorizationCodeGenerator(OAuth2TokenGenerator<OAuth2AuthorizationCode> authorizationCodeGenerator) {
        Assert.notNull(authorizationCodeGenerator, (String)"authorizationCodeGenerator cannot be null");
        this.authorizationCodeGenerator = authorizationCodeGenerator;
    }

    public void setAuthenticationValidator(Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> authenticationValidator) {
        Assert.notNull(authenticationValidator, (String)"authenticationValidator cannot be null");
        this.authenticationValidator = authenticationValidator;
    }

    private static OAuth2Authorization.Builder authorizationBuilder(RegisteredClient registeredClient, Authentication principal, OAuth2AuthorizationRequest authorizationRequest) {
        return OAuth2Authorization.withRegisteredClient(registeredClient).principalName(principal.getName()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).attribute(Principal.class.getName(), principal).attribute(OAuth2AuthorizationRequest.class.getName(), authorizationRequest);
    }

    private static OAuth2TokenContext createAuthorizationCodeTokenContext(OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication, RegisteredClient registeredClient, OAuth2Authorization authorization, Set<String> authorizedScopes) {
        DefaultOAuth2TokenContext.Builder tokenContextBuilder = (DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)DefaultOAuth2TokenContext.builder().registeredClient(registeredClient)).principal((Authentication)authorizationCodeRequestAuthentication.getPrincipal())).authorizationServerContext(AuthorizationServerContextHolder.getContext())).tokenType(new OAuth2TokenType("code"))).authorizedScopes(authorizedScopes)).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE)).authorizationGrant((Authentication)authorizationCodeRequestAuthentication);
        if (authorization != null) {
            tokenContextBuilder.authorization(authorization);
        }
        return tokenContextBuilder.build();
    }

    private static boolean requireAuthorizationConsent(RegisteredClient registeredClient, OAuth2AuthorizationRequest authorizationRequest, OAuth2AuthorizationConsent authorizationConsent) {
        if (!registeredClient.getClientSettings().isRequireAuthorizationConsent()) {
            return false;
        }
        if (authorizationRequest.getScopes().contains("openid") && authorizationRequest.getScopes().size() == 1) {
            return false;
        }
        return authorizationConsent == null || !authorizationConsent.getScopes().containsAll(authorizationRequest.getScopes());
    }

    private static boolean isPrincipalAuthenticated(Authentication principal) {
        return principal != null && !AnonymousAuthenticationToken.class.isAssignableFrom(principal.getClass()) && principal.isAuthenticated();
    }

    private static void throwError(String errorCode, String parameterName, OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication, RegisteredClient registeredClient) {
        OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError(errorCode, parameterName, ERROR_URI, authorizationCodeRequestAuthentication, registeredClient, null);
    }

    private static void throwError(String errorCode, String parameterName, String errorUri, OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication, RegisteredClient registeredClient, OAuth2AuthorizationRequest authorizationRequest) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, errorUri);
        OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError(error, parameterName, authorizationCodeRequestAuthentication, registeredClient, authorizationRequest);
    }

    private static void throwError(OAuth2Error error, String parameterName, OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication, RegisteredClient registeredClient, OAuth2AuthorizationRequest authorizationRequest) {
        String redirectUri = OAuth2AuthorizationCodeRequestAuthenticationProvider.resolveRedirectUri(authorizationRequest, registeredClient);
        if (error.getErrorCode().equals("invalid_request") && (parameterName.equals("client_id") || parameterName.equals("state"))) {
            redirectUri = null;
        }
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthenticationResult = new OAuth2AuthorizationCodeRequestAuthenticationToken(authorizationCodeRequestAuthentication.getAuthorizationUri(), authorizationCodeRequestAuthentication.getClientId(), (Authentication)authorizationCodeRequestAuthentication.getPrincipal(), redirectUri, authorizationCodeRequestAuthentication.getState(), authorizationCodeRequestAuthentication.getScopes(), authorizationCodeRequestAuthentication.getAdditionalParameters());
        throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, authorizationCodeRequestAuthenticationResult);
    }

    private static String resolveRedirectUri(OAuth2AuthorizationRequest authorizationRequest, RegisteredClient registeredClient) {
        if (authorizationRequest != null && StringUtils.hasText((String)authorizationRequest.getRedirectUri())) {
            return authorizationRequest.getRedirectUri();
        }
        if (registeredClient != null) {
            return registeredClient.getRedirectUris().iterator().next();
        }
        return null;
    }
}

