/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web.authentication;

import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientRegistrationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.oidc.http.converter.OidcClientRegistrationHttpMessageConverter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.StringUtils;

public final class OidcClientRegistrationAuthenticationConverter
implements AuthenticationConverter {
    private final HttpMessageConverter<OidcClientRegistration> clientRegistrationHttpMessageConverter = new OidcClientRegistrationHttpMessageConverter();

    public Authentication convert(HttpServletRequest request) {
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        if ("POST".equals(request.getMethod())) {
            OidcClientRegistration clientRegistration;
            try {
                clientRegistration = (OidcClientRegistration)this.clientRegistrationHttpMessageConverter.read(OidcClientRegistration.class, (HttpInputMessage)new ServletServerHttpRequest(request));
            }
            catch (Exception ex) {
                OAuth2Error error = new OAuth2Error("invalid_request", "OpenID Client Registration Error: " + ex.getMessage(), "https://openid.net/specs/openid-connect-registration-1_0.html#RegistrationError");
                throw new OAuth2AuthenticationException(error, (Throwable)ex);
            }
            return new OidcClientRegistrationAuthenticationToken(principal, clientRegistration);
        }
        String clientId = request.getParameter("client_id");
        if (!StringUtils.hasText((String)clientId) || request.getParameterValues("client_id").length != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        return new OidcClientRegistrationAuthenticationToken(principal, clientId);
    }
}

