/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationConsentAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.DelegatingAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationCodeRequestAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationConsentAuthenticationConverter;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.util.RedirectUrlBuilder;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public final class OAuth2AuthorizationEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_AUTHORIZATION_ENDPOINT_URI = "/oauth2/authorize";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher authorizationEndpointMatcher;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationConverter authenticationConverter;
    private AuthenticationSuccessHandler authenticationSuccessHandler = this::sendAuthorizationResponse;
    private AuthenticationFailureHandler authenticationFailureHandler = this::sendErrorResponse;
    private String consentPage;

    public OAuth2AuthorizationEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_AUTHORIZATION_ENDPOINT_URI);
    }

    public OAuth2AuthorizationEndpointFilter(AuthenticationManager authenticationManager, String authorizationEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)authorizationEndpointUri, (String)"authorizationEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.authorizationEndpointMatcher = OAuth2AuthorizationEndpointFilter.createDefaultRequestMatcher(authorizationEndpointUri);
        this.authenticationConverter = new DelegatingAuthenticationConverter(Arrays.asList(new OAuth2AuthorizationCodeRequestAuthenticationConverter(), new OAuth2AuthorizationConsentAuthenticationConverter()));
    }

    private static RequestMatcher createDefaultRequestMatcher(String authorizationEndpointUri) {
        AntPathRequestMatcher authorizationRequestGetMatcher = new AntPathRequestMatcher(authorizationEndpointUri, HttpMethod.GET.name());
        AntPathRequestMatcher authorizationRequestPostMatcher = new AntPathRequestMatcher(authorizationEndpointUri, HttpMethod.POST.name());
        RequestMatcher openidScopeMatcher = request -> {
            String scope = request.getParameter("scope");
            return StringUtils.hasText((String)scope) && scope.contains("openid");
        };
        RequestMatcher responseTypeParameterMatcher = request -> request.getParameter("response_type") != null;
        OrRequestMatcher authorizationRequestMatcher = new OrRequestMatcher(new RequestMatcher[]{authorizationRequestGetMatcher, new AndRequestMatcher(new RequestMatcher[]{authorizationRequestPostMatcher, responseTypeParameterMatcher, openidScopeMatcher})});
        AndRequestMatcher authorizationConsentMatcher = new AndRequestMatcher(new RequestMatcher[]{authorizationRequestPostMatcher, new NegatedRequestMatcher(responseTypeParameterMatcher)});
        return new OrRequestMatcher(new RequestMatcher[]{authorizationRequestMatcher, authorizationConsentMatcher});
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.authorizationEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            Authentication authenticationResult;
            Authentication authentication = this.authenticationConverter.convert(request);
            if (authentication instanceof AbstractAuthenticationToken) {
                ((AbstractAuthenticationToken)authentication).setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            }
            if (!(authenticationResult = this.authenticationManager.authenticate(authentication)).isAuthenticated()) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (authenticationResult instanceof OAuth2AuthorizationConsentAuthenticationToken) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Authorization consent is required");
                }
                this.sendAuthorizationConsent(request, response, (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication, (OAuth2AuthorizationConsentAuthenticationToken)authenticationResult);
                return;
            }
            this.authenticationSuccessHandler.onAuthenticationSuccess(request, response, authenticationResult);
        }
        catch (OAuth2AuthenticationException ex) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Authorization request failed: %s", (Object)ex.getError()), (Throwable)ex);
            }
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)ex);
        }
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, (String)"authenticationDetailsSource cannot be null");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setAuthenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    public void setConsentPage(String consentPage) {
        this.consentPage = consentPage;
    }

    private void sendAuthorizationConsent(HttpServletRequest request, HttpServletResponse response, OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication, OAuth2AuthorizationConsentAuthenticationToken authorizationConsentAuthentication) throws IOException {
        String clientId = authorizationConsentAuthentication.getClientId();
        Authentication principal = (Authentication)authorizationConsentAuthentication.getPrincipal();
        Set<String> requestedScopes = authorizationCodeRequestAuthentication.getScopes();
        Set<String> authorizedScopes = authorizationConsentAuthentication.getScopes();
        String state = authorizationConsentAuthentication.getState();
        if (this.hasConsentUri()) {
            String redirectUri = UriComponentsBuilder.fromUriString((String)this.resolveConsentUri(request)).queryParam("scope", new Object[]{String.join((CharSequence)" ", requestedScopes)}).queryParam("client_id", new Object[]{clientId}).queryParam("state", new Object[]{state}).toUriString();
            this.redirectStrategy.sendRedirect(request, response, redirectUri);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Displaying generated consent screen");
            }
            DefaultConsentPage.displayConsent(request, response, clientId, principal, requestedScopes, authorizedScopes, state);
        }
    }

    private boolean hasConsentUri() {
        return StringUtils.hasText((String)this.consentPage);
    }

    private String resolveConsentUri(HttpServletRequest request) {
        if (UrlUtils.isAbsoluteUrl((String)this.consentPage)) {
            return this.consentPage;
        }
        RedirectUrlBuilder urlBuilder = new RedirectUrlBuilder();
        urlBuilder.setScheme(request.getScheme());
        urlBuilder.setServerName(request.getServerName());
        urlBuilder.setPort(request.getServerPort());
        urlBuilder.setContextPath(request.getContextPath());
        urlBuilder.setPathInfo(this.consentPage);
        return urlBuilder.getUrl();
    }

    private void sendAuthorizationResponse(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        String redirectUri;
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication;
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authorizationCodeRequestAuthentication.getRedirectUri()).queryParam("code", new Object[]{authorizationCodeRequestAuthentication.getAuthorizationCode().getTokenValue()});
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            uriBuilder.queryParam("state", new Object[]{"{state}"});
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("state", authorizationCodeRequestAuthentication.getState());
            redirectUri = uriBuilder.build(queryParams).toString();
        } else {
            redirectUri = uriBuilder.toUriString();
        }
        this.redirectStrategy.sendRedirect(request, response, redirectUri);
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        String redirectUri;
        OAuth2AuthorizationCodeRequestAuthenticationException authorizationCodeRequestAuthenticationException = (OAuth2AuthorizationCodeRequestAuthenticationException)exception;
        OAuth2Error error = authorizationCodeRequestAuthenticationException.getError();
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = authorizationCodeRequestAuthenticationException.getAuthorizationCodeRequestAuthentication();
        if (authorizationCodeRequestAuthentication == null || !StringUtils.hasText((String)authorizationCodeRequestAuthentication.getRedirectUri())) {
            response.sendError(HttpStatus.BAD_REQUEST.value(), error.toString());
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Redirecting to client with error");
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authorizationCodeRequestAuthentication.getRedirectUri()).queryParam("error", new Object[]{error.getErrorCode()});
        if (StringUtils.hasText((String)error.getDescription())) {
            uriBuilder.queryParam("error_description", new Object[]{error.getDescription()});
        }
        if (StringUtils.hasText((String)error.getUri())) {
            uriBuilder.queryParam("error_uri", new Object[]{error.getUri()});
        }
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            uriBuilder.queryParam("state", new Object[]{"{state}"});
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("state", authorizationCodeRequestAuthentication.getState());
            redirectUri = uriBuilder.build(queryParams).toString();
        } else {
            redirectUri = uriBuilder.toUriString();
        }
        this.redirectStrategy.sendRedirect(request, response, redirectUri);
    }

    private static class DefaultConsentPage {
        private static final MediaType TEXT_HTML_UTF8 = new MediaType("text", "html", StandardCharsets.UTF_8);

        private DefaultConsentPage() {
        }

        private static void displayConsent(HttpServletRequest request, HttpServletResponse response, String clientId, Authentication principal, Set<String> requestedScopes, Set<String> authorizedScopes, String state) throws IOException {
            String consentPage = DefaultConsentPage.generateConsentPage(request, clientId, principal, requestedScopes, authorizedScopes, state);
            response.setContentType(TEXT_HTML_UTF8.toString());
            response.setContentLength(consentPage.getBytes(StandardCharsets.UTF_8).length);
            response.getWriter().write(consentPage);
        }

        private static String generateConsentPage(HttpServletRequest request, String clientId, Authentication principal, Set<String> requestedScopes, Set<String> authorizedScopes, String state) {
            HashSet<String> scopesToAuthorize = new HashSet<String>();
            HashSet<String> scopesPreviouslyAuthorized = new HashSet<String>();
            for (String scope : requestedScopes) {
                if (authorizedScopes.contains(scope)) {
                    scopesPreviouslyAuthorized.add(scope);
                    continue;
                }
                if (scope.equals("openid")) continue;
                scopesToAuthorize.add(scope);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("<!DOCTYPE html>");
            builder.append("<html lang=\"en\">");
            builder.append("<head>");
            builder.append("    <meta charset=\"utf-8\">");
            builder.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">");
            builder.append("    <link rel=\"stylesheet\" href=\"https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css\" integrity=\"sha384-JcKb8q3iqJ61gNV9KGb8thSsNjpSL0n8PARn9HuZOnIxN0hoP+VmmDGMN5t9UJ0Z\" crossorigin=\"anonymous\">");
            builder.append("    <title>Consent required</title>");
            builder.append("\t<script>");
            builder.append("\t\tfunction cancelConsent() {");
            builder.append("\t\t\tdocument.consent_form.reset();");
            builder.append("\t\t\tdocument.consent_form.submit();");
            builder.append("\t\t}");
            builder.append("\t</script>");
            builder.append("</head>");
            builder.append("<body>");
            builder.append("<div class=\"container\">");
            builder.append("    <div class=\"py-5\">");
            builder.append("        <h1 class=\"text-center\">Consent required</h1>");
            builder.append("    </div>");
            builder.append("    <div class=\"row\">");
            builder.append("        <div class=\"col text-center\">");
            builder.append("            <p><span class=\"font-weight-bold text-primary\">" + clientId + "</span> wants to access your account <span class=\"font-weight-bold\">" + principal.getName() + "</span></p>");
            builder.append("        </div>");
            builder.append("    </div>");
            builder.append("    <div class=\"row pb-3\">");
            builder.append("        <div class=\"col text-center\">");
            builder.append("            <p>The following permissions are requested by the above app.<br/>Please review these and consent if you approve.</p>");
            builder.append("        </div>");
            builder.append("    </div>");
            builder.append("    <div class=\"row\">");
            builder.append("        <div class=\"col text-center\">");
            builder.append("            <form name=\"consent_form\" method=\"post\" action=\"" + request.getRequestURI() + "\">");
            builder.append("                <input type=\"hidden\" name=\"client_id\" value=\"" + clientId + "\">");
            builder.append("                <input type=\"hidden\" name=\"state\" value=\"" + state + "\">");
            for (String scope : scopesToAuthorize) {
                builder.append("                <div class=\"form-group form-check py-1\">");
                builder.append("                    <input class=\"form-check-input\" type=\"checkbox\" name=\"scope\" value=\"" + scope + "\" id=\"" + scope + "\">");
                builder.append("                    <label class=\"form-check-label\" for=\"" + scope + "\">" + scope + "</label>");
                builder.append("                </div>");
            }
            if (!scopesPreviouslyAuthorized.isEmpty()) {
                builder.append("                <p>You have already granted the following permissions to the above app:</p>");
                for (String scope : scopesPreviouslyAuthorized) {
                    builder.append("                <div class=\"form-group form-check py-1\">");
                    builder.append("                    <input class=\"form-check-input\" type=\"checkbox\" name=\"scope\" id=\"" + scope + "\" checked disabled>");
                    builder.append("                    <label class=\"form-check-label\" for=\"" + scope + "\">" + scope + "</label>");
                    builder.append("                </div>");
                }
            }
            builder.append("                <div class=\"form-group pt-3\">");
            builder.append("                    <button class=\"btn btn-primary btn-lg\" type=\"submit\" id=\"submit-consent\">Submit Consent</button>");
            builder.append("                </div>");
            builder.append("                <div class=\"form-group\">");
            builder.append("                    <button class=\"btn btn-link regular\" type=\"button\" onclick=\"cancelConsent();\" id=\"cancel-consent\">Cancel</button>");
            builder.append("                </div>");
            builder.append("            </form>");
            builder.append("        </div>");
            builder.append("    </div>");
            builder.append("    <div class=\"row pt-4\">");
            builder.append("        <div class=\"col text-center\">");
            builder.append("            <p><small>Your consent to provide access is required.<br/>If you do not approve, click Cancel, in which case no information will be shared with the app.</small></p>");
            builder.append("        </div>");
            builder.append("    </div>");
            builder.append("</div>");
            builder.append("</body>");
            builder.append("</html>");
            return builder.toString();
        }
    }
}

