/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.authentication;

import java.util.Collections;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.server.authorization.util.SpringAuthorizationServerVersion;
import org.springframework.util.Assert;

public class OidcClientRegistrationAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = SpringAuthorizationServerVersion.SERIAL_VERSION_UID;
    private final Authentication principal;
    private final OidcClientRegistration clientRegistration;
    private final String clientId;

    public OidcClientRegistrationAuthenticationToken(Authentication principal, OidcClientRegistration clientRegistration) {
        super(Collections.emptyList());
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
        this.principal = principal;
        this.clientRegistration = clientRegistration;
        this.clientId = null;
        this.setAuthenticated(principal.isAuthenticated());
    }

    public OidcClientRegistrationAuthenticationToken(Authentication principal, String clientId) {
        super(Collections.emptyList());
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        this.principal = principal;
        this.clientRegistration = null;
        this.clientId = clientId;
        this.setAuthenticated(principal.isAuthenticated());
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return "";
    }

    public OidcClientRegistration getClientRegistration() {
        return this.clientRegistration;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }
}

