/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationConsentAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.util.Assert;

public final class OAuth2AuthorizationConsentAuthenticationContext
implements OAuth2AuthenticationContext {
    private final Map<Object, Object> context;

    private OAuth2AuthorizationConsentAuthenticationContext(Map<Object, Object> context) {
        this.context = Collections.unmodifiableMap(new HashMap<Object, Object>(context));
    }

    @Override
    @Nullable
    public <V> V get(Object key) {
        return (V)(this.hasKey(key) ? this.context.get(key) : null);
    }

    @Override
    public boolean hasKey(Object key) {
        Assert.notNull((Object)key, (String)"key cannot be null");
        return this.context.containsKey(key);
    }

    public OAuth2AuthorizationConsent.Builder getAuthorizationConsent() {
        return this.get(OAuth2AuthorizationConsent.Builder.class);
    }

    public RegisteredClient getRegisteredClient() {
        return this.get(RegisteredClient.class);
    }

    public OAuth2Authorization getAuthorization() {
        return this.get(OAuth2Authorization.class);
    }

    public OAuth2AuthorizationRequest getAuthorizationRequest() {
        return this.get(OAuth2AuthorizationRequest.class);
    }

    public static Builder with(OAuth2AuthorizationConsentAuthenticationToken authentication) {
        return new Builder(authentication);
    }

    public static final class Builder
    extends OAuth2AuthenticationContext.AbstractBuilder<OAuth2AuthorizationConsentAuthenticationContext, Builder> {
        private Builder(OAuth2AuthorizationConsentAuthenticationToken authentication) {
            super((Authentication)authentication);
        }

        public Builder authorizationConsent(OAuth2AuthorizationConsent.Builder authorizationConsent) {
            return (Builder)this.put(OAuth2AuthorizationConsent.Builder.class, authorizationConsent);
        }

        public Builder registeredClient(RegisteredClient registeredClient) {
            return (Builder)this.put(RegisteredClient.class, registeredClient);
        }

        public Builder authorization(OAuth2Authorization authorization) {
            return (Builder)this.put(OAuth2Authorization.class, authorization);
        }

        public Builder authorizationRequest(OAuth2AuthorizationRequest authorizationRequest) {
            return (Builder)this.put(OAuth2AuthorizationRequest.class, authorizationRequest);
        }

        @Override
        public OAuth2AuthorizationConsentAuthenticationContext build() {
            Assert.notNull(this.get(OAuth2AuthorizationConsent.Builder.class), (String)"authorizationConsentBuilder cannot be null");
            Assert.notNull(this.get(RegisteredClient.class), (String)"registeredClient cannot be null");
            Assert.notNull(this.get(OAuth2Authorization.class), (String)"authorization cannot be null");
            Assert.notNull(this.get(OAuth2AuthorizationRequest.class), (String)"authorizationRequest cannot be null");
            return new OAuth2AuthorizationConsentAuthenticationContext(this.getContext());
        }
    }
}

