/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.util.matcher;

import java.util.Map;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.security.messaging.util.matcher.SimpMessageTypeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public final class PathPatternMessageMatcher
implements MessageMatcher<Object> {
    public static final MessageMatcher<Object> NULL_DESTINATION_MATCHER = message -> PathPatternMessageMatcher.getDestination(message) == null;
    private final PathPattern pattern;
    private final PathContainer.Options options;
    private MessageMatcher<Object> messageTypeMatcher = ANY_MESSAGE;

    private PathPatternMessageMatcher(PathPattern pattern, PathContainer.Options options) {
        this.options = options;
        this.pattern = pattern;
    }

    public static Builder withDefaults() {
        return new Builder(PathPatternParser.defaultInstance);
    }

    public static Builder withPathPatternParser(PathPatternParser parser) {
        return new Builder(parser);
    }

    void setMessageTypeMatcher(MessageMatcher<Object> messageTypeMatcher) {
        this.messageTypeMatcher = messageTypeMatcher;
    }

    @Override
    public boolean matches(Message<?> message) {
        return this.matcher(message).isMatch();
    }

    @Override
    public MessageMatcher.MatchResult matcher(Message<?> message) {
        if (!this.messageTypeMatcher.matches(message)) {
            return MessageMatcher.MatchResult.notMatch();
        }
        String destination = PathPatternMessageMatcher.getDestination(message);
        if (destination == null) {
            return MessageMatcher.MatchResult.notMatch();
        }
        PathContainer destinationPathContainer = PathContainer.parsePath((String)destination, (PathContainer.Options)this.options);
        PathPattern.PathMatchInfo pathMatchInfo = this.pattern.matchAndExtract(destinationPathContainer);
        return pathMatchInfo != null ? MessageMatcher.MatchResult.match(pathMatchInfo.getUriVariables()) : MessageMatcher.MatchResult.notMatch();
    }

    @Nullable
    private static String getDestination(Message<?> message) {
        return SimpMessageHeaderAccessor.getDestination((Map)message.getHeaders());
    }

    public static class Builder {
        private final PathPatternParser parser;

        Builder(PathPatternParser parser) {
            this.parser = parser;
        }

        public PathPatternMessageMatcher matcher(String pattern) {
            return this.matcher(null, pattern);
        }

        public PathPatternMessageMatcher matcher(@Nullable SimpMessageType type, String pattern) {
            Assert.notNull((Object)pattern, (String)"pattern must not be null");
            PathPattern pathPattern = this.parser.parse(pattern);
            PathPatternMessageMatcher matcher = new PathPatternMessageMatcher(pathPattern, this.parser.getPathOptions());
            if (type != null) {
                matcher.setMessageTypeMatcher(new SimpMessageTypeMatcher(type));
            }
            return matcher;
        }
    }
}

