/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.web.socket.server;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.DefaultCsrfToken;
import org.springframework.security.web.csrf.DeferredCsrfToken;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public final class CsrfTokenHandshakeInterceptor
implements HandshakeInterceptor {
    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        HttpServletRequest httpRequest = ((ServletServerHttpRequest)request).getServletRequest();
        DeferredCsrfToken deferredCsrfToken = (DeferredCsrfToken)httpRequest.getAttribute(DeferredCsrfToken.class.getName());
        if (deferredCsrfToken == null) {
            return true;
        }
        CsrfToken csrfToken = deferredCsrfToken.get();
        DefaultCsrfToken resolvedCsrfToken = new DefaultCsrfToken(csrfToken.getHeaderName(), csrfToken.getParameterName(), csrfToken.getToken());
        attributes.put(CsrfToken.class.getName(), resolvedCsrfToken);
        return true;
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
    }
}

