/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.access.intercept;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.messaging.access.intercept.MessageAuthorizationContext;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.security.messaging.util.matcher.SimpDestinationMessageMatcher;
import org.springframework.security.messaging.util.matcher.SimpMessageTypeMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.function.SingletonSupplier;

public final class MessageMatcherDelegatingAuthorizationManager
implements AuthorizationManager<Message<?>> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final List<Entry<AuthorizationManager<MessageAuthorizationContext<?>>>> mappings;

    private MessageMatcherDelegatingAuthorizationManager(List<Entry<AuthorizationManager<MessageAuthorizationContext<?>>>> mappings) {
        Assert.notEmpty(mappings, (String)"mappings cannot be empty");
        this.mappings = mappings;
    }

    @Deprecated
    public AuthorizationDecision check(Supplier<Authentication> authentication, Message<?> message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)LogMessage.format((String)"Authorizing message", (Object[])new Object[0]));
        }
        for (Entry<AuthorizationManager<MessageAuthorizationContext<?>>> mapping : this.mappings) {
            MessageMatcher<?> matcher = mapping.getMessageMatcher();
            MessageAuthorizationContext<?> authorizationContext = this.authorizationContext(matcher, message);
            if (authorizationContext == null) continue;
            AuthorizationManager<MessageAuthorizationContext<?>> manager = mapping.getEntry();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Checking authorization on message using %s", manager));
            }
            return manager.check(authentication, authorizationContext);
        }
        this.logger.trace((Object)"Abstaining since did not find matching MessageMatcher");
        return null;
    }

    private MessageAuthorizationContext<?> authorizationContext(MessageMatcher<?> matcher, Message<?> message) {
        if (!matcher.matches(message)) {
            return null;
        }
        if (matcher instanceof SimpDestinationMessageMatcher) {
            SimpDestinationMessageMatcher simp = (SimpDestinationMessageMatcher)matcher;
            return new MessageAuthorizationContext(message, simp.extractPathVariables(message));
        }
        if (matcher instanceof Builder.LazySimpDestinationMessageMatcher) {
            Builder.LazySimpDestinationMessageMatcher path = (Builder.LazySimpDestinationMessageMatcher)matcher;
            return new MessageAuthorizationContext(message, path.extractPathVariables(message));
        }
        return new MessageAuthorizationContext(message);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class Entry<T> {
        private final MessageMatcher<?> messageMatcher;
        private final T entry;

        Entry(MessageMatcher requestMatcher, T entry) {
            this.messageMatcher = requestMatcher;
            this.entry = entry;
        }

        MessageMatcher<?> getMessageMatcher() {
            return this.messageMatcher;
        }

        T getEntry() {
            return this.entry;
        }
    }

    public static final class Builder {
        private final List<Entry<AuthorizationManager<MessageAuthorizationContext<?>>>> mappings = new ArrayList();
        private Supplier<PathMatcher> pathMatcher = AntPathMatcher::new;

        public Constraint anyMessage() {
            return this.matchers(MessageMatcher.ANY_MESSAGE);
        }

        public Constraint nullDestMatcher() {
            return this.matchers(SimpDestinationMessageMatcher.NULL_DESTINATION_MATCHER);
        }

        public Constraint simpTypeMatchers(SimpMessageType ... typesToMatch) {
            MessageMatcher[] typeMatchers = new MessageMatcher[typesToMatch.length];
            for (int i = 0; i < typesToMatch.length; ++i) {
                SimpMessageType typeToMatch = typesToMatch[i];
                typeMatchers[i] = new SimpMessageTypeMatcher(typeToMatch);
            }
            return this.matchers(typeMatchers);
        }

        public Constraint simpDestMatchers(String ... patterns) {
            return this.simpDestMatchers((SimpMessageType)null, patterns);
        }

        public Constraint simpMessageDestMatchers(String ... patterns) {
            return this.simpDestMatchers(SimpMessageType.MESSAGE, patterns);
        }

        public Constraint simpSubscribeDestMatchers(String ... patterns) {
            return this.simpDestMatchers(SimpMessageType.SUBSCRIBE, patterns);
        }

        private Constraint simpDestMatchers(SimpMessageType type, String ... patterns) {
            ArrayList<LazySimpDestinationMessageMatcher> matchers = new ArrayList<LazySimpDestinationMessageMatcher>(patterns.length);
            for (String pattern : patterns) {
                LazySimpDestinationMessageMatcher matcher = new LazySimpDestinationMessageMatcher(pattern, type);
                matchers.add(matcher);
            }
            return new Constraint(matchers);
        }

        public Builder simpDestPathMatcher(PathMatcher pathMatcher) {
            Assert.notNull((Object)pathMatcher, (String)"pathMatcher cannot be null");
            this.pathMatcher = () -> pathMatcher;
            return this;
        }

        public Builder simpDestPathMatcher(Supplier<PathMatcher> pathMatcher) {
            Assert.notNull(pathMatcher, (String)"pathMatcher cannot be null");
            this.pathMatcher = pathMatcher;
            return this;
        }

        public Constraint matchers(MessageMatcher<?> ... matchers) {
            ArrayList builders = new ArrayList(matchers.length);
            for (MessageMatcher<?> matcher : matchers) {
                builders.add(matcher);
            }
            return new Constraint(builders);
        }

        public AuthorizationManager<Message<?>> build() {
            return new MessageMatcherDelegatingAuthorizationManager(this.mappings);
        }

        public final class Constraint {
            private final List<? extends MessageMatcher<?>> messageMatchers;

            private Constraint(List<? extends MessageMatcher<?>> messageMatchers) {
                Assert.notEmpty(messageMatchers, (String)"messageMatchers cannot be null or empty");
                this.messageMatchers = messageMatchers;
            }

            public Builder hasRole(String role) {
                return this.access((AuthorizationManager<MessageAuthorizationContext<?>>)AuthorityAuthorizationManager.hasRole((String)role));
            }

            public Builder hasAnyRole(String ... roles) {
                return this.access((AuthorizationManager<MessageAuthorizationContext<?>>)AuthorityAuthorizationManager.hasAnyRole((String[])roles));
            }

            public Builder hasAuthority(String authority) {
                return this.access((AuthorizationManager<MessageAuthorizationContext<?>>)AuthorityAuthorizationManager.hasAuthority((String)authority));
            }

            public Builder hasAnyAuthority(String ... authorities) {
                return this.access((AuthorizationManager<MessageAuthorizationContext<?>>)AuthorityAuthorizationManager.hasAnyAuthority((String[])authorities));
            }

            public Builder permitAll() {
                return this.access((authentication, context) -> new AuthorizationDecision(true));
            }

            public Builder denyAll() {
                return this.access((authorization, context) -> new AuthorizationDecision(false));
            }

            public Builder authenticated() {
                return this.access((AuthorizationManager<MessageAuthorizationContext<?>>)AuthenticatedAuthorizationManager.authenticated());
            }

            public Builder fullyAuthenticated() {
                return this.access((AuthorizationManager<MessageAuthorizationContext<?>>)AuthenticatedAuthorizationManager.fullyAuthenticated());
            }

            public Builder rememberMe() {
                return this.access((AuthorizationManager<MessageAuthorizationContext<?>>)AuthenticatedAuthorizationManager.rememberMe());
            }

            public Builder anonymous() {
                return this.access((AuthorizationManager<MessageAuthorizationContext<?>>)AuthenticatedAuthorizationManager.anonymous());
            }

            public Builder access(AuthorizationManager<MessageAuthorizationContext<?>> authorizationManager) {
                for (MessageMatcher<?> messageMatcher : this.messageMatchers) {
                    Builder.this.mappings.add(new Entry(messageMatcher, authorizationManager));
                }
                return Builder.this;
            }
        }

        private final class LazySimpDestinationMessageMatcher
        implements MessageMatcher<Object> {
            private final Supplier<SimpDestinationMessageMatcher> delegate = SingletonSupplier.of(() -> {
                PathMatcher pathMatcher = Builder.this.pathMatcher.get();
                if (type == null) {
                    return new SimpDestinationMessageMatcher(pattern, pathMatcher);
                }
                if (SimpMessageType.MESSAGE == type) {
                    return SimpDestinationMessageMatcher.createMessageMatcher(pattern, pathMatcher);
                }
                if (SimpMessageType.SUBSCRIBE == type) {
                    return SimpDestinationMessageMatcher.createSubscribeMatcher(pattern, pathMatcher);
                }
                throw new IllegalStateException(type + " is not supported since it does not have a destination");
            });

            private LazySimpDestinationMessageMatcher(String pattern, SimpMessageType type) {
            }

            @Override
            public boolean matches(Message<?> message) {
                return this.delegate.get().matches(message);
            }

            Map<String, String> extractPathVariables(Message<?> message) {
                return this.delegate.get().extractPathVariables(message);
            }
        }
    }
}

