/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

final class LdapEncoder {
    private static final String[] FILTER_ESCAPE_TABLE = new String[93];

    private LdapEncoder() {
    }

    static String filterEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder encodedValue = new StringBuilder(value.length() * 2);
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            encodedValue.append(ch < FILTER_ESCAPE_TABLE.length ? FILTER_ESCAPE_TABLE[ch] : Character.valueOf(ch));
        }
        return encodedValue.toString();
    }

    static {
        for (char c = '\u0000'; c < FILTER_ESCAPE_TABLE.length; c = (char)(c + '\u0001')) {
            LdapEncoder.FILTER_ESCAPE_TABLE[c] = String.valueOf(c);
        }
        LdapEncoder.FILTER_ESCAPE_TABLE[42] = "\\2a";
        LdapEncoder.FILTER_ESCAPE_TABLE[40] = "\\28";
        LdapEncoder.FILTER_ESCAPE_TABLE[41] = "\\29";
        LdapEncoder.FILTER_ESCAPE_TABLE[92] = "\\5c";
        LdapEncoder.FILTER_ESCAPE_TABLE[0] = "\\00";
    }
}

