/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jwt.crypto.sign;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.springframework.security.jwt.codec.Codecs;

class RsaKeyHelper {
    private static String BEGIN = "-----BEGIN";
    private static Pattern PEM_DATA = Pattern.compile("-----BEGIN (.*)-----(.*)-----END (.*)-----", 32);
    private static final Pattern SSH_PUB_KEY = Pattern.compile("ssh-(rsa|dsa) ([A-Za-z0-9/+]+=*) (.*)");

    RsaKeyHelper() {
    }

    static KeyPair parseKeyPair(String pemData) {
        Matcher m = PEM_DATA.matcher(pemData);
        if (!m.matches()) {
            throw new IllegalArgumentException("String is not PEM encoded data");
        }
        String type = m.group(1);
        if (!type.equals("RSA PRIVATE KEY")) {
            throw new IllegalArgumentException("Only private key data is currently supported");
        }
        String content = m.group(2);
        try {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])Codecs.b64Decode(Codecs.utf8Encode(content))));
            if (seq.size() != 9) {
                throw new IllegalArgumentException("Invalid RSA Key ASN1 sequence.");
            }
            RSAPrivateKey key = RSAPrivateKey.getInstance((Object)seq);
            RSAPublicKeySpec pubSpec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
            RSAPrivateCrtKeySpec privSpec = new RSAPrivateCrtKeySpec(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrime1(), key.getPrime2(), key.getExponent1(), key.getExponent2(), key.getCoefficient());
            KeyFactory fact = KeyFactory.getInstance("RSA");
            return new KeyPair(fact.generatePublic(pubSpec), fact.generatePrivate(privSpec));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    static RSAPublicKey parsePublicKey(String key) {
        Matcher m = SSH_PUB_KEY.matcher(key);
        if (m.matches()) {
            String alg = m.group(1);
            String encKey = m.group(2);
            if (!"rsa".equalsIgnoreCase(alg)) {
                throw new IllegalArgumentException("Only RSA is currently supported, but algorithm was " + alg);
            }
            return RsaKeyHelper.parseSSHPublicKey(encKey);
        }
        if (!key.startsWith(BEGIN)) {
            return RsaKeyHelper.parseSSHPublicKey(key);
        }
        KeyPair kp = RsaKeyHelper.parseKeyPair(key);
        if (kp.getPublic() == null) {
            throw new IllegalArgumentException("Key data does not contain a public key");
        }
        return (RSAPublicKey)kp.getPublic();
    }

    private static RSAPublicKey parseSSHPublicKey(String encKey) {
        byte[] byArray = new byte[11];
        byArray[3] = 7;
        byArray[4] = 115;
        byArray[5] = 115;
        byArray[6] = 104;
        byArray[7] = 45;
        byArray[8] = 114;
        byArray[9] = 115;
        byArray[10] = 97;
        byte[] PREFIX = byArray;
        ByteArrayInputStream in = new ByteArrayInputStream(Codecs.b64Decode(Codecs.utf8Encode(encKey)));
        byte[] prefix = new byte[11];
        try {
            if (in.read(prefix) != 11 || !Arrays.equals(PREFIX, prefix)) {
                throw new IllegalArgumentException("SSH key prefix not found");
            }
            BigInteger e = new BigInteger(RsaKeyHelper.readBigInteger(in));
            BigInteger n = new BigInteger(RsaKeyHelper.readBigInteger(in));
            return RsaKeyHelper.createPublicKey(n, e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static RSAPublicKey createPublicKey(BigInteger n, BigInteger e) {
        try {
            return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(n, e));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static byte[] readBigInteger(ByteArrayInputStream in) throws IOException {
        byte[] b = new byte[4];
        if (in.read(b) != 4) {
            throw new IOException("Expected length data as 4 bytes");
        }
        int l = b[0] << 24 | b[1] << 16 | b[2] << 8 | b[3];
        if (in.read(b = new byte[l]) != l) {
            throw new IOException("Expected " + l + " key bytes");
        }
        return b;
    }
}

