/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jwt;

import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHeader;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.codec.Codecs;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;

class JwtImpl
implements Jwt {
    private final JwtHeader header;
    private final byte[] content;
    private final byte[] crypto;
    private String claims;

    JwtImpl(JwtHeader header, byte[] content, byte[] crypto) {
        this.header = header;
        this.content = content;
        this.crypto = crypto;
        this.claims = Codecs.utf8Decode(content);
    }

    public void verifySignature(SignatureVerifier verifier) {
        verifier.verify(this.signingInput(), this.crypto);
    }

    private byte[] signingInput() {
        return Codecs.concat(Codecs.b64UrlEncode(this.header.bytes()), JwtHelper.PERIOD, Codecs.b64UrlEncode(this.content));
    }

    public byte[] bytes() {
        return Codecs.concat(Codecs.b64UrlEncode(this.header.bytes()), JwtHelper.PERIOD, Codecs.b64UrlEncode(this.content), JwtHelper.PERIOD, Codecs.b64UrlEncode(this.crypto));
    }

    public String getClaims() {
        return Codecs.utf8Decode(this.content);
    }

    public String getEncoded() {
        return Codecs.utf8Decode(this.bytes());
    }

    public String toString() {
        return this.header + " " + this.claims + " [" + this.crypto.length + " crypto bytes]";
    }
}

