/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractInterceptUrlConfigurer;
import org.springframework.security.config.annotation.web.configurers.AbstractRequestMatcherMappingConfigurer;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.expression.WebExpressionVoter;
import org.springframework.security.web.util.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpressionUrlAuthorizationConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractInterceptUrlConfigurer<H, ExpressionUrlAuthorizationConfigurer<H>, AuthorizedUrl> {
    static final String permitAll = "permitAll";
    private static final String denyAll = "denyAll";
    private static final String anonymous = "anonymous";
    private static final String authenticated = "authenticated";
    private static final String fullyAuthenticated = "fullyAuthenticated";
    private static final String rememberMe = "rememberMe";
    private SecurityExpressionHandler<FilterInvocation> expressionHandler = new DefaultWebSecurityExpressionHandler();

    public ExpressionUrlAuthorizationConfigurer<H> expressionHandler(SecurityExpressionHandler<FilterInvocation> expressionHandler) {
        this.expressionHandler = expressionHandler;
        return this;
    }

    @Override
    protected final AuthorizedUrl chainRequestMatchersInternal(List<RequestMatcher> requestMatchers) {
        return new AuthorizedUrl(requestMatchers);
    }

    @Override
    final List<AccessDecisionVoter> getDecisionVoters() {
        ArrayList<AccessDecisionVoter> decisionVoters = new ArrayList<AccessDecisionVoter>();
        WebExpressionVoter expressionVoter = new WebExpressionVoter();
        expressionVoter.setExpressionHandler(this.expressionHandler);
        decisionVoters.add((AccessDecisionVoter)expressionVoter);
        return decisionVoters;
    }

    final ExpressionBasedFilterInvocationSecurityMetadataSource createMetadataSource() {
        LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap = this.createRequestMap();
        if (requestMap.isEmpty()) {
            throw new IllegalStateException("At least one mapping is required (i.e. authorizeUrls().anyRequest.authenticated())");
        }
        return new ExpressionBasedFilterInvocationSecurityMetadataSource(requestMap, this.expressionHandler);
    }

    private ExpressionUrlAuthorizationConfigurer<H> interceptUrl(Iterable<? extends RequestMatcher> requestMatchers, Collection<ConfigAttribute> configAttributes) {
        for (RequestMatcher requestMatcher : requestMatchers) {
            this.addMapping(new AbstractRequestMatcherMappingConfigurer.UrlMapping(requestMatcher, configAttributes));
        }
        return this;
    }

    private static String hasRole(String role) {
        Assert.notNull((Object)role, (String)"role cannot be null");
        if (role.startsWith("ROLE_")) {
            throw new IllegalArgumentException("role should not start with 'ROLE_' since it is automatically inserted. Got '" + role + "'");
        }
        return "hasRole('ROLE_" + role + "')";
    }

    private static String hasAuthority(String authority) {
        return "hasAuthority('" + authority + "')";
    }

    private static String hasAnyAuthority(String ... authorities) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)"','");
        return "hasAnyAuthority('" + anyAuthorities + "')";
    }

    private static String hasIpAddress(String ipAddressExpression) {
        return "hasIpAddress('" + ipAddressExpression + "')";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class AuthorizedUrl {
        private List<RequestMatcher> requestMatchers;
        private boolean not;

        private AuthorizedUrl(List<RequestMatcher> requestMatchers) {
            this.requestMatchers = requestMatchers;
        }

        public AuthorizedUrl not() {
            this.not = true;
            return this;
        }

        public ExpressionUrlAuthorizationConfigurer<H> hasRole(String role) {
            return this.access(ExpressionUrlAuthorizationConfigurer.hasRole(role));
        }

        public ExpressionUrlAuthorizationConfigurer<H> hasAuthority(String authority) {
            return this.access(ExpressionUrlAuthorizationConfigurer.hasAuthority(authority));
        }

        public ExpressionUrlAuthorizationConfigurer<H> hasAnyAuthority(String ... authorities) {
            return this.access(ExpressionUrlAuthorizationConfigurer.hasAnyAuthority(authorities));
        }

        public ExpressionUrlAuthorizationConfigurer<H> hasIpAddress(String ipaddressExpression) {
            return this.access(ExpressionUrlAuthorizationConfigurer.hasIpAddress(ipaddressExpression));
        }

        public ExpressionUrlAuthorizationConfigurer<H> permitAll() {
            return this.access(ExpressionUrlAuthorizationConfigurer.permitAll);
        }

        public ExpressionUrlAuthorizationConfigurer<H> anonymous() {
            return this.access(ExpressionUrlAuthorizationConfigurer.anonymous);
        }

        public ExpressionUrlAuthorizationConfigurer<H> rememberMe() {
            return this.access(ExpressionUrlAuthorizationConfigurer.rememberMe);
        }

        public ExpressionUrlAuthorizationConfigurer<H> denyAll() {
            return this.access(ExpressionUrlAuthorizationConfigurer.denyAll);
        }

        public ExpressionUrlAuthorizationConfigurer<H> authenticated() {
            return this.access(ExpressionUrlAuthorizationConfigurer.authenticated);
        }

        public ExpressionUrlAuthorizationConfigurer<H> fullyAuthenticated() {
            return this.access(ExpressionUrlAuthorizationConfigurer.fullyAuthenticated);
        }

        public ExpressionUrlAuthorizationConfigurer<H> access(String attribute) {
            if (this.not) {
                attribute = "!" + attribute;
            }
            ExpressionUrlAuthorizationConfigurer.this.interceptUrl(this.requestMatchers, SecurityConfig.createList((String[])new String[]{attribute}));
            return ExpressionUrlAuthorizationConfigurer.this;
        }
    }
}

