/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.List;
import javax.servlet.Filter;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractRequestMatcherMappingConfigurer;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractInterceptUrlConfigurer<H extends HttpSecurityBuilder<H>, C, R>
extends AbstractRequestMatcherMappingConfigurer<H, R, DefaultSecurityFilterChain>
implements SecurityConfigurer<DefaultSecurityFilterChain, H> {
    private Boolean filterSecurityInterceptorOncePerRequest;
    private AccessDecisionManager accessDecisionManager;

    AbstractInterceptUrlConfigurer() {
    }

    public C accessDecisionManager(AccessDecisionManager accessDecisionManager) {
        this.accessDecisionManager = accessDecisionManager;
        return this.getSelf();
    }

    public C filterSecurityInterceptorOncePerRequest(boolean filterSecurityInterceptorOncePerRequest) {
        this.filterSecurityInterceptorOncePerRequest = filterSecurityInterceptorOncePerRequest;
        return this.getSelf();
    }

    @Override
    public void configure(H http) throws Exception {
        FilterInvocationSecurityMetadataSource metadataSource = this.createMetadataSource();
        if (metadataSource == null) {
            return;
        }
        FilterSecurityInterceptor securityInterceptor = this.createFilterSecurityInterceptor(metadataSource, http.getAuthenticationManager());
        if (this.filterSecurityInterceptorOncePerRequest != null) {
            securityInterceptor.setObserveOncePerRequest(this.filterSecurityInterceptorOncePerRequest.booleanValue());
        }
        securityInterceptor = this.postProcess(securityInterceptor);
        http.addFilter((Filter)securityInterceptor);
        http.setSharedObject(FilterSecurityInterceptor.class, (FilterSecurityInterceptor)securityInterceptor);
    }

    abstract FilterInvocationSecurityMetadataSource createMetadataSource();

    abstract List<AccessDecisionVoter> getDecisionVoters();

    private AccessDecisionManager createDefaultAccessDecisionManager() {
        return new AffirmativeBased(this.getDecisionVoters());
    }

    private AccessDecisionManager getAccessDecisionManager() {
        if (this.accessDecisionManager == null) {
            this.accessDecisionManager = this.createDefaultAccessDecisionManager();
        }
        return this.accessDecisionManager;
    }

    private FilterSecurityInterceptor createFilterSecurityInterceptor(FilterInvocationSecurityMetadataSource metadataSource, AuthenticationManager authenticationManager) throws Exception {
        FilterSecurityInterceptor securityInterceptor = new FilterSecurityInterceptor();
        securityInterceptor.setSecurityMetadataSource(metadataSource);
        securityInterceptor.setAccessDecisionManager(this.getAccessDecisionManager());
        securityInterceptor.setAuthenticationManager(authenticationManager);
        securityInterceptor.afterPropertiesSet();
        return securityInterceptor;
    }

    private C getSelf() {
        return (C)this;
    }
}

