/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.PermitAllSupport;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthenticationFilterConfigurer<B extends HttpSecurityBuilder<B>, T extends AbstractAuthenticationFilterConfigurer<B, T, F>, F extends AbstractAuthenticationProcessingFilter>
extends AbstractHttpConfigurer<B> {
    private final F authFilter;
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource;
    private AuthenticationSuccessHandler successHandler = new SavedRequestAwareAuthenticationSuccessHandler();
    private LoginUrlAuthenticationEntryPoint authenticationEntryPoint;
    private boolean customLoginPage;
    private String loginPage;
    private String loginProcessingUrl;
    private AuthenticationFailureHandler failureHandler;
    private boolean permitAll;
    private String failureUrl;

    protected AbstractAuthenticationFilterConfigurer(F authenticationFilter, String defaultLoginProcessingUrl) {
        this.authFilter = authenticationFilter;
        this.loginUrl("/login");
        this.failureUrl("/login?error");
        this.loginProcessingUrl(defaultLoginProcessingUrl);
        this.customLoginPage = false;
    }

    public final T defaultSuccessUrl(String defaultSuccessUrl) {
        return this.defaultSuccessUrl(defaultSuccessUrl, false);
    }

    public final T defaultSuccessUrl(String defaultSuccessUrl, boolean alwaysUse) {
        SavedRequestAwareAuthenticationSuccessHandler handler = new SavedRequestAwareAuthenticationSuccessHandler();
        handler.setDefaultTargetUrl(defaultSuccessUrl);
        handler.setAlwaysUseDefaultTargetUrl(alwaysUse);
        return this.successHandler((AuthenticationSuccessHandler)handler);
    }

    public final T loginUrl(String loginUrl) {
        this.loginProcessingUrl(loginUrl);
        return this.loginPage(loginUrl);
    }

    public T loginProcessingUrl(String loginProcessingUrl) {
        this.loginProcessingUrl = loginProcessingUrl;
        this.authFilter.setFilterProcessesUrl(loginProcessingUrl);
        return this.getSelf();
    }

    public final T authenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
        return this.getSelf();
    }

    public final T successHandler(AuthenticationSuccessHandler successHandler) {
        this.successHandler = successHandler;
        return this.getSelf();
    }

    public final T permitAll() {
        return this.permitAll(true);
    }

    public final T permitAll(boolean permitAll) {
        this.permitAll = permitAll;
        return this.getSelf();
    }

    public final T failureUrl(String authenticationFailureUrl) {
        T result = this.failureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler(authenticationFailureUrl));
        this.failureUrl = authenticationFailureUrl;
        return result;
    }

    public final T failureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        this.failureUrl = null;
        this.failureHandler = authenticationFailureHandler;
        return this.getSelf();
    }

    @Override
    public void init(B http) throws Exception {
        if (this.permitAll) {
            PermitAllSupport.permitAll(http, new String[]{this.loginPage, this.loginProcessingUrl, this.failureUrl});
        }
        http.setSharedObject(AuthenticationEntryPoint.class, (LoginUrlAuthenticationEntryPoint)this.postProcess(this.authenticationEntryPoint));
    }

    @Override
    public void configure(B http) throws Exception {
        RememberMeServices rememberMeServices;
        SessionAuthenticationStrategy sessionAuthenticationStrategy;
        PortMapper portMapper = http.getSharedObject(PortMapper.class);
        if (portMapper != null) {
            this.authenticationEntryPoint.setPortMapper(portMapper);
        }
        this.authFilter.setAuthenticationManager(http.getAuthenticationManager());
        this.authFilter.setAuthenticationSuccessHandler(this.successHandler);
        this.authFilter.setAuthenticationFailureHandler(this.failureHandler);
        if (this.authenticationDetailsSource != null) {
            this.authFilter.setAuthenticationDetailsSource(this.authenticationDetailsSource);
        }
        if ((sessionAuthenticationStrategy = http.getSharedObject(SessionAuthenticationStrategy.class)) != null) {
            this.authFilter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        }
        if ((rememberMeServices = http.getSharedObject(RememberMeServices.class)) != null) {
            this.authFilter.setRememberMeServices(rememberMeServices);
        }
        AbstractAuthenticationProcessingFilter filter = (AbstractAuthenticationProcessingFilter)this.postProcess(this.authFilter);
        http.addFilter((Filter)filter);
    }

    protected T loginPage(String loginPage) {
        this.loginPage = loginPage;
        this.authenticationEntryPoint = new LoginUrlAuthenticationEntryPoint(loginPage);
        this.customLoginPage = true;
        return this.getSelf();
    }

    public final boolean isCustomLoginPage() {
        return this.customLoginPage;
    }

    protected final F getAuthenticationFilter() {
        return this.authFilter;
    }

    protected final String getLoginPage() {
        return this.loginPage;
    }

    protected final String getLoginProcessingUrl() {
        return this.loginProcessingUrl;
    }

    protected final String getFailureUrl() {
        return this.failureUrl;
    }

    private T getSelf() {
        return (T)this;
    }
}

