/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.saml2;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opensaml.core.Version;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml5AuthenticationProvider;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.OpenSaml5AuthenticationTokenConverter;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationTokenConverter;
import org.springframework.security.saml2.provider.service.web.Saml2WebSsoAuthenticationRequestFilter;
import org.springframework.security.saml2.provider.service.web.authentication.OpenSaml5AuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2AuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2WebSsoAuthenticationFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.ParameterRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatchers;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class Saml2LoginConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractAuthenticationFilterConfigurer<B, Saml2LoginConfigurer<B>, Saml2WebSsoAuthenticationFilter> {
    private static final boolean USE_OPENSAML_5 = Version.getVersion().startsWith("5");
    private String loginPage;
    private String authenticationRequestUri = "/saml2/authenticate";
    private String[] authenticationRequestParams = new String[]{"registrationId={registrationId}"};
    private RequestMatcher authenticationRequestMatcher;
    private Saml2AuthenticationRequestResolver authenticationRequestResolver;
    private RequestMatcher loginProcessingUrl;
    private RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private AuthenticationConverter authenticationConverter;
    private AuthenticationManager authenticationManager;
    private Saml2WebSsoAuthenticationFilter saml2WebSsoAuthenticationFilter;

    public Saml2LoginConfigurer<B> authenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
        return this;
    }

    public Saml2LoginConfigurer<B> authenticationManager(AuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
        return this;
    }

    public Saml2LoginConfigurer<B> relyingPartyRegistrationRepository(RelyingPartyRegistrationRepository repo) {
        this.relyingPartyRegistrationRepository = repo;
        return this;
    }

    @Override
    public Saml2LoginConfigurer<B> loginPage(String loginPage) {
        Assert.hasText((String)loginPage, (String)"loginPage cannot be empty");
        this.loginPage = loginPage;
        return this;
    }

    public Saml2LoginConfigurer<B> authenticationRequestResolver(Saml2AuthenticationRequestResolver authenticationRequestResolver) {
        Assert.notNull((Object)authenticationRequestResolver, (String)"authenticationRequestResolver cannot be null");
        this.authenticationRequestResolver = authenticationRequestResolver;
        return this;
    }

    @Deprecated
    public Saml2LoginConfigurer<B> authenticationRequestUri(String authenticationRequestUri) {
        return this.authenticationRequestUriQuery(authenticationRequestUri);
    }

    public Saml2LoginConfigurer<B> authenticationRequestUriQuery(String authenticationRequestUriQuery) {
        Assert.state((boolean)authenticationRequestUriQuery.contains("{registrationId}"), (String)"authenticationRequestUri must contain {registrationId} path variable or query value");
        String[] parts = authenticationRequestUriQuery.split("[?&]");
        this.authenticationRequestUri = parts[0];
        this.authenticationRequestParams = new String[parts.length - 1];
        System.arraycopy(parts, 1, this.authenticationRequestParams, 0, parts.length - 1);
        this.authenticationRequestMatcher = new PathQueryRequestMatcher((RequestMatcher)this.getRequestMatcherBuilder().matcher(this.authenticationRequestUri), this.authenticationRequestParams);
        return this;
    }

    @Override
    public Saml2LoginConfigurer<B> loginProcessingUrl(String loginProcessingUrl) {
        Assert.hasText((String)loginProcessingUrl, (String)"loginProcessingUrl cannot be empty");
        this.loginProcessingUrl = this.getRequestMatcherBuilder().matcher(loginProcessingUrl);
        return this;
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return this.getRequestMatcherBuilder().matcher(loginProcessingUrl);
    }

    @Override
    public void init(B http) throws Exception {
        this.registerDefaultCsrfOverride(http);
        this.relyingPartyRegistrationRepository(http);
        this.saml2WebSsoAuthenticationFilter = new Saml2WebSsoAuthenticationFilter(this.getAuthenticationConverter(http));
        this.saml2WebSsoAuthenticationFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        this.saml2WebSsoAuthenticationFilter.setRequiresAuthenticationRequestMatcher(this.getLoginProcessingEndpoint());
        this.setAuthenticationRequestRepository(http, this.saml2WebSsoAuthenticationFilter);
        this.setAuthenticationFilter(this.saml2WebSsoAuthenticationFilter);
        if (StringUtils.hasText((String)this.loginPage)) {
            super.loginPage(this.loginPage);
            super.init(http);
        } else {
            boolean singleProvider;
            Map<String, String> providerUrlMap = this.getIdentityProviderUrlMap(this.authenticationRequestUri, this.authenticationRequestParams, this.relyingPartyRegistrationRepository);
            boolean bl = singleProvider = providerUrlMap.size() == 1;
            if (singleProvider) {
                this.updateAuthenticationDefaults();
                this.updateAccessDefaults(http);
                String loginUrl = providerUrlMap.entrySet().iterator().next().getKey();
                this.registerAuthenticationEntryPoint(http, this.getLoginEntryPoint(http, loginUrl));
            } else {
                super.init(http);
            }
        }
        this.initDefaultLoginFilter(http);
        if (this.authenticationManager == null) {
            this.registerDefaultAuthenticationProvider(http);
        }
    }

    @Override
    public void configure(B http) throws Exception {
        Saml2WebSsoAuthenticationRequestFilter filter = this.getAuthenticationRequestFilter(http);
        filter.setAuthenticationRequestRepository(this.getAuthenticationRequestRepository(http));
        http.addFilter((Filter)this.postProcess(filter));
        super.configure(http);
        if (this.authenticationManager != null) {
            this.saml2WebSsoAuthenticationFilter.setAuthenticationManager(this.authenticationManager);
        }
    }

    RelyingPartyRegistrationRepository relyingPartyRegistrationRepository(B http) {
        if (this.relyingPartyRegistrationRepository == null) {
            this.relyingPartyRegistrationRepository = this.getSharedOrBean(http, RelyingPartyRegistrationRepository.class);
        }
        return this.relyingPartyRegistrationRepository;
    }

    private AuthenticationEntryPoint getLoginEntryPoint(B http, String providerLoginPage) {
        PathPatternRequestMatcher loginPageMatcher = this.getRequestMatcherBuilder().matcher(this.getLoginPage());
        PathPatternRequestMatcher faviconMatcher = this.getRequestMatcherBuilder().matcher("/favicon.ico");
        RequestMatcher defaultEntryPointMatcher = this.getAuthenticationEntryPointMatcher(http);
        AndRequestMatcher defaultLoginPageMatcher = new AndRequestMatcher(new RequestMatcher[]{new OrRequestMatcher(new RequestMatcher[]{loginPageMatcher, faviconMatcher}), defaultEntryPointMatcher});
        NegatedRequestMatcher notXRequestedWith = new NegatedRequestMatcher((RequestMatcher)new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
        LinkedHashMap<AndRequestMatcher, LoginUrlAuthenticationEntryPoint> entryPoints = new LinkedHashMap<AndRequestMatcher, LoginUrlAuthenticationEntryPoint>();
        LoginUrlAuthenticationEntryPoint loginUrlEntryPoint = new LoginUrlAuthenticationEntryPoint(providerLoginPage);
        PortResolver portResolver = this.getBeanOrNull(http, PortResolver.class);
        if (portResolver != null) {
            loginUrlEntryPoint.setPortResolver(portResolver);
        }
        entryPoints.put(new AndRequestMatcher(new RequestMatcher[]{notXRequestedWith, new NegatedRequestMatcher((RequestMatcher)defaultLoginPageMatcher)}), loginUrlEntryPoint);
        DelegatingAuthenticationEntryPoint loginEntryPoint = new DelegatingAuthenticationEntryPoint(entryPoints);
        loginEntryPoint.setDefaultEntryPoint(this.getAuthenticationEntryPoint());
        return loginEntryPoint;
    }

    private void setAuthenticationRequestRepository(B http, Saml2WebSsoAuthenticationFilter saml2WebSsoAuthenticationFilter) {
        saml2WebSsoAuthenticationFilter.setAuthenticationRequestRepository(this.getAuthenticationRequestRepository(http));
    }

    private Saml2WebSsoAuthenticationRequestFilter getAuthenticationRequestFilter(B http) {
        Saml2AuthenticationRequestResolver authenticationRequestResolver = this.getAuthenticationRequestResolver(http);
        return new Saml2WebSsoAuthenticationRequestFilter(authenticationRequestResolver);
    }

    private Saml2AuthenticationRequestResolver getAuthenticationRequestResolver(B http) {
        if (this.authenticationRequestResolver != null) {
            return this.authenticationRequestResolver;
        }
        Saml2AuthenticationRequestResolver bean = this.getBeanOrNull(http, Saml2AuthenticationRequestResolver.class);
        if (bean != null) {
            return bean;
        }
        if (USE_OPENSAML_5) {
            OpenSaml5AuthenticationRequestResolver openSamlAuthenticationRequestResolver = new OpenSaml5AuthenticationRequestResolver(this.relyingPartyRegistrationRepository(http));
            openSamlAuthenticationRequestResolver.setRequestMatcher(this.getAuthenticationRequestMatcher());
            return openSamlAuthenticationRequestResolver;
        }
        throw new IllegalArgumentException("Spring Security does not support OpenSAML " + Version.getVersion() + ". Please use OpenSAML 5");
    }

    private RequestMatcher getAuthenticationRequestMatcher() {
        if (this.authenticationRequestMatcher == null) {
            this.authenticationRequestMatcher = RequestMatchers.anyOf((RequestMatcher[])new RequestMatcher[]{this.getRequestMatcherBuilder().matcher("/saml2/authenticate/{registrationId}"), new PathQueryRequestMatcher((RequestMatcher)this.getRequestMatcherBuilder().matcher(this.authenticationRequestUri), this.authenticationRequestParams)});
        }
        return this.authenticationRequestMatcher;
    }

    private RequestMatcher getLoginProcessingEndpoint() {
        if (this.loginProcessingUrl == null) {
            this.loginProcessingUrl = RequestMatchers.anyOf((RequestMatcher[])new RequestMatcher[]{this.getRequestMatcherBuilder().matcher("/login/saml2/sso/{registrationId}"), this.getRequestMatcherBuilder().matcher("/login/saml2/sso")});
        }
        return this.loginProcessingUrl;
    }

    private AuthenticationConverter getAuthenticationConverter(B http) {
        if (this.authenticationConverter != null) {
            return this.authenticationConverter;
        }
        AuthenticationConverter authenticationConverterBean = (AuthenticationConverter)this.getBeanOrNull(http, Saml2AuthenticationTokenConverter.class);
        if (authenticationConverterBean != null) {
            return authenticationConverterBean;
        }
        if (USE_OPENSAML_5) {
            authenticationConverterBean = (AuthenticationConverter)this.getBeanOrNull(http, OpenSaml5AuthenticationTokenConverter.class);
            if (authenticationConverterBean != null) {
                return authenticationConverterBean;
            }
            OpenSaml5AuthenticationTokenConverter converter = new OpenSaml5AuthenticationTokenConverter(this.relyingPartyRegistrationRepository);
            converter.setAuthenticationRequestRepository(this.getAuthenticationRequestRepository(http));
            converter.setRequestMatcher(this.getLoginProcessingEndpoint());
            return converter;
        }
        throw new IllegalArgumentException("Spring Security does not support OpenSAML " + Version.getVersion() + ". Please use OpenSAML 5");
    }

    private void registerDefaultAuthenticationProvider(B http) {
        if (USE_OPENSAML_5) {
            OpenSaml5AuthenticationProvider provider = this.getBeanOrNull(http, OpenSaml5AuthenticationProvider.class);
            if (provider == null) {
                http.authenticationProvider((AuthenticationProvider)this.postProcess(new OpenSaml5AuthenticationProvider()));
            }
        } else {
            throw new IllegalArgumentException("Spring Security does not support OpenSAML " + Version.getVersion() + ". Please use OpenSAML 5");
        }
    }

    private void registerDefaultCsrfOverride(B http) {
        CsrfConfigurer csrf = http.getConfigurer(CsrfConfigurer.class);
        if (csrf == null) {
            return;
        }
        csrf.ignoringRequestMatchers(this.getLoginProcessingEndpoint());
    }

    private void initDefaultLoginFilter(B http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter == null || this.isCustomLoginPage()) {
            return;
        }
        loginPageGeneratingFilter.setSaml2LoginEnabled(true);
        loginPageGeneratingFilter.setSaml2AuthenticationUrlToProviderName(this.getIdentityProviderUrlMap(this.authenticationRequestUri, this.authenticationRequestParams, this.relyingPartyRegistrationRepository));
        loginPageGeneratingFilter.setLoginPageUrl(this.getLoginPage());
        loginPageGeneratingFilter.setFailureUrl(this.getFailureUrl());
    }

    private Map<String, String> getIdentityProviderUrlMap(String authRequestPrefixUrl, String[] authRequestQueryParams, RelyingPartyRegistrationRepository idpRepo) {
        LinkedHashMap<String, String> idps = new LinkedHashMap<String, String>();
        if (idpRepo instanceof Iterable) {
            Iterable repo = (Iterable)idpRepo;
            StringBuilder authRequestQuery = new StringBuilder("?");
            for (String authRequestQueryParam : authRequestQueryParams) {
                authRequestQuery.append(authRequestQueryParam + "&");
            }
            authRequestQuery.deleteCharAt(authRequestQuery.length() - 1);
            String authenticationRequestUriQuery = authRequestPrefixUrl + String.valueOf(authRequestQuery);
            repo.forEach(p -> idps.put(authenticationRequestUriQuery.replace("{registrationId}", p.getRegistrationId()), p.getRegistrationId()));
        }
        return idps;
    }

    private Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> getAuthenticationRequestRepository(B http) {
        Saml2AuthenticationRequestRepository repository = this.getBeanOrNull(http, Saml2AuthenticationRequestRepository.class);
        if (repository == null) {
            return new HttpSessionSaml2AuthenticationRequestRepository();
        }
        return repository;
    }

    private <C> C getSharedOrBean(B http, Class<C> clazz) {
        C shared = http.getSharedObject(clazz);
        if (shared != null) {
            return shared;
        }
        return this.getBeanOrNull(http, clazz);
    }

    private <C> C getBeanOrNull(B http, Class<C> clazz) {
        ApplicationContext context = http.getSharedObject(ApplicationContext.class);
        if (context == null) {
            return null;
        }
        return (C)context.getBeanProvider(clazz).getIfUnique();
    }

    private <C> void setSharedObject(B http, Class<C> clazz, C object) {
        if (http.getSharedObject(clazz) == null) {
            http.setSharedObject(clazz, object);
        }
    }

    static class PathQueryRequestMatcher
    implements RequestMatcher {
        private final RequestMatcher matcher;

        PathQueryRequestMatcher(RequestMatcher pathMatcher, String ... params) {
            ArrayList<Object> matchers = new ArrayList<Object>();
            matchers.add(pathMatcher);
            for (String param : params) {
                String[] parts = param.split("=");
                if (parts.length == 1) {
                    matchers.add(new ParameterRequestMatcher(parts[0]));
                    continue;
                }
                matchers.add(new ParameterRequestMatcher(parts[0], parts[1]));
            }
            this.matcher = new AndRequestMatcher(matchers);
        }

        public boolean matches(HttpServletRequest request) {
            return this.matcher(request).isMatch();
        }

        public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
            return this.matcher.matcher(request);
        }
    }
}

