/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.builders;

import jakarta.servlet.Filter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.UnreachableFilterChainException;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;

final class WebSecurityFilterChainValidator
implements FilterChainProxy.FilterChainValidator {
    private final Log logger = LogFactory.getLog(this.getClass());

    WebSecurityFilterChainValidator() {
    }

    public void validate(FilterChainProxy filterChainProxy) {
        List chains = filterChainProxy.getFilterChains();
        this.checkForAnyRequestRequestMatcher(chains);
        this.checkForDuplicateMatchers(chains);
        this.checkAuthorizationFilters(chains);
    }

    private void checkForAnyRequestRequestMatcher(List<SecurityFilterChain> chains) {
        DefaultSecurityFilterChain anyRequestFilterChain = null;
        for (SecurityFilterChain chain : chains) {
            DefaultSecurityFilterChain defaultChain;
            if (anyRequestFilterChain != null) {
                String message = "A filter chain that matches any request [" + anyRequestFilterChain + "] has already been configured, which means that this filter chain [" + chain + "] will never get invoked. Please use `HttpSecurity#securityMatcher` to ensure that there is only one filter chain configured for 'any request' and that the 'any request' filter chain is published last.";
                throw new UnreachableFilterChainException(message, anyRequestFilterChain, chain);
            }
            if (!(chain instanceof DefaultSecurityFilterChain) || !((defaultChain = (DefaultSecurityFilterChain)chain).getRequestMatcher() instanceof AnyRequestMatcher)) continue;
            anyRequestFilterChain = defaultChain;
        }
    }

    private void checkForDuplicateMatchers(List<SecurityFilterChain> chains) {
        DefaultSecurityFilterChain filterChain = null;
        for (SecurityFilterChain chain : chains) {
            DefaultSecurityFilterChain defaultChain;
            if (filterChain != null && chain instanceof DefaultSecurityFilterChain && (defaultChain = (DefaultSecurityFilterChain)chain).getRequestMatcher().equals(filterChain.getRequestMatcher())) {
                throw new UnreachableFilterChainException("The FilterChainProxy contains two filter chains using the matcher " + defaultChain.getRequestMatcher(), (SecurityFilterChain)filterChain, (SecurityFilterChain)defaultChain);
            }
            if (!(chain instanceof DefaultSecurityFilterChain)) continue;
            filterChain = defaultChain = (DefaultSecurityFilterChain)chain;
        }
    }

    private void checkAuthorizationFilters(List<SecurityFilterChain> chains) {
        Filter authorizationFilter = null;
        Filter filterSecurityInterceptor = null;
        for (SecurityFilterChain chain : chains) {
            for (Filter filter : chain.getFilters()) {
                if (filter instanceof AuthorizationFilter) {
                    authorizationFilter = filter;
                }
                if (!(filter instanceof FilterSecurityInterceptor)) continue;
                filterSecurityInterceptor = filter;
            }
            if (authorizationFilter != null && filterSecurityInterceptor != null) {
                this.logger.warn((Object)"It is not recommended to use authorizeRequests in the configuration. Please only use authorizeHttpRequests");
            }
            if (filterSecurityInterceptor != null) {
                this.logger.warn((Object)"Usage of authorizeRequests is deprecated. Please use authorizeHttpRequests in the configuration");
            }
            authorizationFilter = null;
            filterSecurityInterceptor = null;
        }
    }
}

