/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthoritiesAuthorizationManager;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.SecuredAuthorizationManager;
import org.springframework.security.config.annotation.method.configuration.DeferringObservationAuthorizationManager;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class SecuredMethodSecurityConfiguration
implements ImportAware,
AopInfrastructureBean {
    private int interceptorOrderOffset;

    SecuredMethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor securedAuthorizationMethodInterceptor(ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ObjectProvider<AuthorizationEventPublisher> eventPublisherProvider, ObjectProvider<ObservationRegistry> registryProvider, ObjectProvider<RoleHierarchy> roleHierarchyProvider, SecuredMethodSecurityConfiguration configuration) {
        SecuredAuthorizationManager secured = new SecuredAuthorizationManager();
        AuthoritiesAuthorizationManager authoritiesAuthorizationManager = new AuthoritiesAuthorizationManager();
        RoleHierarchy roleHierarchy = (RoleHierarchy)roleHierarchyProvider.getIfAvailable(NullRoleHierarchy::new);
        authoritiesAuthorizationManager.setRoleHierarchy(roleHierarchy);
        secured.setAuthoritiesAuthorizationManager((AuthorizationManager)authoritiesAuthorizationManager);
        SecurityContextHolderStrategy strategy = (SecurityContextHolderStrategy)strategyProvider.getIfAvailable(SecurityContextHolder::getContextHolderStrategy);
        DeferringObservationAuthorizationManager manager = new DeferringObservationAuthorizationManager(registryProvider, secured);
        AuthorizationManagerBeforeMethodInterceptor interceptor = AuthorizationManagerBeforeMethodInterceptor.secured(manager);
        interceptor.setOrder(interceptor.getOrder() + configuration.interceptorOrderOffset);
        interceptor.setSecurityContextHolderStrategy(strategy);
        eventPublisherProvider.ifAvailable(arg_0 -> ((AuthorizationManagerBeforeMethodInterceptor)interceptor).setAuthorizationEventPublisher(arg_0));
        return interceptor;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        EnableMethodSecurity annotation = (EnableMethodSecurity)importMetadata.getAnnotations().get(EnableMethodSecurity.class).synthesize();
        this.interceptorOrderOffset = annotation.offset();
    }
}

