/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.builders;

import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ObservationAuthenticationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.AbstractConfiguredSecurityBuilder;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.FilterOrderRegistration;
import org.springframework.security.config.annotation.web.configurers.AnonymousConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.CorsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.config.annotation.web.configurers.JeeConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.PasswordManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.PortMapperConfigurer;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.config.annotation.web.configurers.RequestCacheConfigurer;
import org.springframework.security.config.annotation.web.configurers.SecurityContextConfigurer;
import org.springframework.security.config.annotation.web.configurers.ServletApiConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.X509Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LogoutConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public final class HttpSecurity
extends AbstractConfiguredSecurityBuilder<DefaultSecurityFilterChain, HttpSecurity>
implements SecurityBuilder<DefaultSecurityFilterChain>,
HttpSecurityBuilder<HttpSecurity> {
    private static final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";
    private static final String HANDLER_MAPPING_INTROSPECTOR = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
    private static final boolean mvcPresent = ClassUtils.isPresent((String)"org.springframework.web.servlet.handler.HandlerMappingIntrospector", (ClassLoader)HttpSecurity.class.getClassLoader());
    private final RequestMatcherConfigurer requestMatcherConfigurer;
    private List<OrderedFilter> filters = new ArrayList<OrderedFilter>();
    private RequestMatcher requestMatcher = AnyRequestMatcher.INSTANCE;
    private FilterOrderRegistration filterOrders = new FilterOrderRegistration();
    private AuthenticationManager authenticationManager;

    public HttpSecurity(ObjectPostProcessor<Object> objectPostProcessor, AuthenticationManagerBuilder authenticationBuilder, Map<Class<?>, Object> sharedObjects) {
        super(objectPostProcessor);
        Assert.notNull((Object)authenticationBuilder, (String)"authenticationBuilder cannot be null");
        this.setSharedObject(AuthenticationManagerBuilder.class, authenticationBuilder);
        for (Map.Entry<Class<?>, Object> entry : sharedObjects.entrySet()) {
            this.setSharedObject(entry.getKey(), entry.getValue());
        }
        ApplicationContext context = (ApplicationContext)sharedObjects.get(ApplicationContext.class);
        this.requestMatcherConfigurer = new RequestMatcherConfigurer(context);
    }

    private ApplicationContext getContext() {
        return this.getSharedObject(ApplicationContext.class);
    }

    public HeadersConfigurer<HttpSecurity> headers() throws Exception {
        return this.getOrApply(new HeadersConfigurer());
    }

    public HttpSecurity headers(Customizer<HeadersConfigurer<HttpSecurity>> headersCustomizer) throws Exception {
        headersCustomizer.customize(this.getOrApply(new HeadersConfigurer()));
        return this;
    }

    public CorsConfigurer<HttpSecurity> cors() throws Exception {
        return this.getOrApply(new CorsConfigurer());
    }

    public HttpSecurity cors(Customizer<CorsConfigurer<HttpSecurity>> corsCustomizer) throws Exception {
        corsCustomizer.customize(this.getOrApply(new CorsConfigurer()));
        return this;
    }

    public SessionManagementConfigurer<HttpSecurity> sessionManagement() throws Exception {
        return this.getOrApply(new SessionManagementConfigurer());
    }

    public HttpSecurity sessionManagement(Customizer<SessionManagementConfigurer<HttpSecurity>> sessionManagementCustomizer) throws Exception {
        sessionManagementCustomizer.customize(this.getOrApply(new SessionManagementConfigurer()));
        return this;
    }

    public PortMapperConfigurer<HttpSecurity> portMapper() throws Exception {
        return this.getOrApply(new PortMapperConfigurer());
    }

    public HttpSecurity portMapper(Customizer<PortMapperConfigurer<HttpSecurity>> portMapperCustomizer) throws Exception {
        portMapperCustomizer.customize(this.getOrApply(new PortMapperConfigurer()));
        return this;
    }

    public JeeConfigurer<HttpSecurity> jee() throws Exception {
        return this.getOrApply(new JeeConfigurer());
    }

    public HttpSecurity jee(Customizer<JeeConfigurer<HttpSecurity>> jeeCustomizer) throws Exception {
        jeeCustomizer.customize(this.getOrApply(new JeeConfigurer()));
        return this;
    }

    public X509Configurer<HttpSecurity> x509() throws Exception {
        return this.getOrApply(new X509Configurer());
    }

    public HttpSecurity x509(Customizer<X509Configurer<HttpSecurity>> x509Customizer) throws Exception {
        x509Customizer.customize(this.getOrApply(new X509Configurer()));
        return this;
    }

    public RememberMeConfigurer<HttpSecurity> rememberMe() throws Exception {
        return this.getOrApply(new RememberMeConfigurer());
    }

    public HttpSecurity rememberMe(Customizer<RememberMeConfigurer<HttpSecurity>> rememberMeCustomizer) throws Exception {
        rememberMeCustomizer.customize(this.getOrApply(new RememberMeConfigurer()));
        return this;
    }

    @Deprecated
    public ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry authorizeRequests() throws Exception {
        ApplicationContext context = this.getContext();
        return this.getOrApply(new ExpressionUrlAuthorizationConfigurer(context)).getRegistry();
    }

    @Deprecated
    public HttpSecurity authorizeRequests(Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> authorizeRequestsCustomizer) throws Exception {
        ApplicationContext context = this.getContext();
        authorizeRequestsCustomizer.customize(this.getOrApply(new ExpressionUrlAuthorizationConfigurer(context)).getRegistry());
        return this;
    }

    public AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizeHttpRequests() throws Exception {
        ApplicationContext context = this.getContext();
        return this.getOrApply(new AuthorizeHttpRequestsConfigurer(context)).getRegistry();
    }

    public HttpSecurity authorizeHttpRequests(Customizer<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry> authorizeHttpRequestsCustomizer) throws Exception {
        ApplicationContext context = this.getContext();
        authorizeHttpRequestsCustomizer.customize(this.getOrApply(new AuthorizeHttpRequestsConfigurer(context)).getRegistry());
        return this;
    }

    public RequestCacheConfigurer<HttpSecurity> requestCache() throws Exception {
        return this.getOrApply(new RequestCacheConfigurer());
    }

    public HttpSecurity requestCache(Customizer<RequestCacheConfigurer<HttpSecurity>> requestCacheCustomizer) throws Exception {
        requestCacheCustomizer.customize(this.getOrApply(new RequestCacheConfigurer()));
        return this;
    }

    public ExceptionHandlingConfigurer<HttpSecurity> exceptionHandling() throws Exception {
        return this.getOrApply(new ExceptionHandlingConfigurer());
    }

    public HttpSecurity exceptionHandling(Customizer<ExceptionHandlingConfigurer<HttpSecurity>> exceptionHandlingCustomizer) throws Exception {
        exceptionHandlingCustomizer.customize(this.getOrApply(new ExceptionHandlingConfigurer()));
        return this;
    }

    public SecurityContextConfigurer<HttpSecurity> securityContext() throws Exception {
        return this.getOrApply(new SecurityContextConfigurer());
    }

    public HttpSecurity securityContext(Customizer<SecurityContextConfigurer<HttpSecurity>> securityContextCustomizer) throws Exception {
        securityContextCustomizer.customize(this.getOrApply(new SecurityContextConfigurer()));
        return this;
    }

    public ServletApiConfigurer<HttpSecurity> servletApi() throws Exception {
        return this.getOrApply(new ServletApiConfigurer());
    }

    public HttpSecurity servletApi(Customizer<ServletApiConfigurer<HttpSecurity>> servletApiCustomizer) throws Exception {
        servletApiCustomizer.customize(this.getOrApply(new ServletApiConfigurer()));
        return this;
    }

    public CsrfConfigurer<HttpSecurity> csrf() throws Exception {
        ApplicationContext context = this.getContext();
        return this.getOrApply(new CsrfConfigurer(context));
    }

    public HttpSecurity csrf(Customizer<CsrfConfigurer<HttpSecurity>> csrfCustomizer) throws Exception {
        ApplicationContext context = this.getContext();
        csrfCustomizer.customize(this.getOrApply(new CsrfConfigurer(context)));
        return this;
    }

    public LogoutConfigurer<HttpSecurity> logout() throws Exception {
        return this.getOrApply(new LogoutConfigurer());
    }

    public HttpSecurity logout(Customizer<LogoutConfigurer<HttpSecurity>> logoutCustomizer) throws Exception {
        logoutCustomizer.customize(this.getOrApply(new LogoutConfigurer()));
        return this;
    }

    public AnonymousConfigurer<HttpSecurity> anonymous() throws Exception {
        return this.getOrApply(new AnonymousConfigurer());
    }

    public HttpSecurity anonymous(Customizer<AnonymousConfigurer<HttpSecurity>> anonymousCustomizer) throws Exception {
        anonymousCustomizer.customize(this.getOrApply(new AnonymousConfigurer()));
        return this;
    }

    public FormLoginConfigurer<HttpSecurity> formLogin() throws Exception {
        return this.getOrApply(new FormLoginConfigurer());
    }

    public HttpSecurity formLogin(Customizer<FormLoginConfigurer<HttpSecurity>> formLoginCustomizer) throws Exception {
        formLoginCustomizer.customize(this.getOrApply(new FormLoginConfigurer()));
        return this;
    }

    public Saml2LoginConfigurer<HttpSecurity> saml2Login() throws Exception {
        return this.getOrApply(new Saml2LoginConfigurer());
    }

    public HttpSecurity saml2Login(Customizer<Saml2LoginConfigurer<HttpSecurity>> saml2LoginCustomizer) throws Exception {
        saml2LoginCustomizer.customize(this.getOrApply(new Saml2LoginConfigurer()));
        return this;
    }

    public HttpSecurity saml2Logout(Customizer<Saml2LogoutConfigurer<HttpSecurity>> saml2LogoutCustomizer) throws Exception {
        saml2LogoutCustomizer.customize(this.getOrApply(new Saml2LogoutConfigurer(this.getContext())));
        return this;
    }

    public Saml2LogoutConfigurer<HttpSecurity> saml2Logout() throws Exception {
        return this.getOrApply(new Saml2LogoutConfigurer(this.getContext()));
    }

    public OAuth2LoginConfigurer<HttpSecurity> oauth2Login() throws Exception {
        return this.getOrApply(new OAuth2LoginConfigurer());
    }

    public HttpSecurity oauth2Login(Customizer<OAuth2LoginConfigurer<HttpSecurity>> oauth2LoginCustomizer) throws Exception {
        oauth2LoginCustomizer.customize(this.getOrApply(new OAuth2LoginConfigurer()));
        return this;
    }

    public OAuth2ClientConfigurer<HttpSecurity> oauth2Client() throws Exception {
        OAuth2ClientConfigurer<HttpSecurity> configurer = this.getOrApply(new OAuth2ClientConfigurer());
        this.postProcess(configurer);
        return configurer;
    }

    public HttpSecurity oauth2Client(Customizer<OAuth2ClientConfigurer<HttpSecurity>> oauth2ClientCustomizer) throws Exception {
        oauth2ClientCustomizer.customize(this.getOrApply(new OAuth2ClientConfigurer()));
        return this;
    }

    public OAuth2ResourceServerConfigurer<HttpSecurity> oauth2ResourceServer() throws Exception {
        OAuth2ResourceServerConfigurer<HttpSecurity> configurer = this.getOrApply(new OAuth2ResourceServerConfigurer(this.getContext()));
        this.postProcess(configurer);
        return configurer;
    }

    public HttpSecurity oauth2ResourceServer(Customizer<OAuth2ResourceServerConfigurer<HttpSecurity>> oauth2ResourceServerCustomizer) throws Exception {
        OAuth2ResourceServerConfigurer configurer = this.getOrApply(new OAuth2ResourceServerConfigurer(this.getContext()));
        this.postProcess(configurer);
        oauth2ResourceServerCustomizer.customize(configurer);
        return this;
    }

    public ChannelSecurityConfigurer.ChannelRequestMatcherRegistry requiresChannel() throws Exception {
        ApplicationContext context = this.getContext();
        return this.getOrApply(new ChannelSecurityConfigurer(context)).getRegistry();
    }

    public HttpSecurity requiresChannel(Customizer<ChannelSecurityConfigurer.ChannelRequestMatcherRegistry> requiresChannelCustomizer) throws Exception {
        ApplicationContext context = this.getContext();
        requiresChannelCustomizer.customize(this.getOrApply(new ChannelSecurityConfigurer(context)).getRegistry());
        return this;
    }

    public HttpBasicConfigurer<HttpSecurity> httpBasic() throws Exception {
        return this.getOrApply(new HttpBasicConfigurer());
    }

    public HttpSecurity httpBasic(Customizer<HttpBasicConfigurer<HttpSecurity>> httpBasicCustomizer) throws Exception {
        httpBasicCustomizer.customize(this.getOrApply(new HttpBasicConfigurer()));
        return this;
    }

    public HttpSecurity passwordManagement(Customizer<PasswordManagementConfigurer<HttpSecurity>> passwordManagementCustomizer) throws Exception {
        passwordManagementCustomizer.customize(this.getOrApply(new PasswordManagementConfigurer()));
        return this;
    }

    public HttpSecurity authenticationManager(AuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
        return this;
    }

    @Override
    public <C> void setSharedObject(Class<C> sharedType, C object) {
        super.setSharedObject(sharedType, object);
    }

    @Override
    protected void beforeConfigure() throws Exception {
        if (this.authenticationManager != null) {
            this.setSharedObject(AuthenticationManager.class, this.authenticationManager);
        } else {
            ObservationRegistry registry = this.getObservationRegistry();
            AuthenticationManager manager = (AuthenticationManager)this.getAuthenticationRegistry().build();
            if (!registry.isNoop()) {
                this.setSharedObject(AuthenticationManager.class, new ObservationAuthenticationManager(registry, manager));
            } else {
                this.setSharedObject(AuthenticationManager.class, manager);
            }
        }
    }

    @Override
    protected DefaultSecurityFilterChain performBuild() {
        ExpressionUrlAuthorizationConfigurer expressionConfigurer = this.getConfigurer(ExpressionUrlAuthorizationConfigurer.class);
        AuthorizeHttpRequestsConfigurer httpConfigurer = this.getConfigurer(AuthorizeHttpRequestsConfigurer.class);
        boolean oneConfigurerPresent = expressionConfigurer == null ^ httpConfigurer == null;
        Assert.state((expressionConfigurer == null && httpConfigurer == null || oneConfigurerPresent ? 1 : 0) != 0, (String)"authorizeHttpRequests cannot be used in conjunction with authorizeRequests. Please select just one.");
        this.filters.sort((Comparator<OrderedFilter>)OrderComparator.INSTANCE);
        ArrayList<Filter> sortedFilters = new ArrayList<Filter>(this.filters.size());
        for (Filter filter : this.filters) {
            sortedFilters.add(((OrderedFilter)filter).filter);
        }
        return new DefaultSecurityFilterChain(this.requestMatcher, sortedFilters);
    }

    @Override
    public HttpSecurity authenticationProvider(AuthenticationProvider authenticationProvider) {
        this.getAuthenticationRegistry().authenticationProvider(authenticationProvider);
        return this;
    }

    @Override
    public HttpSecurity userDetailsService(UserDetailsService userDetailsService) throws Exception {
        this.getAuthenticationRegistry().userDetailsService(userDetailsService);
        return this;
    }

    private AuthenticationManagerBuilder getAuthenticationRegistry() {
        return this.getSharedObject(AuthenticationManagerBuilder.class);
    }

    @Override
    public HttpSecurity addFilterAfter(Filter filter, Class<? extends Filter> afterFilter) {
        return this.addFilterAtOffsetOf(filter, 1, afterFilter);
    }

    @Override
    public HttpSecurity addFilterBefore(Filter filter, Class<? extends Filter> beforeFilter) {
        return this.addFilterAtOffsetOf(filter, -1, beforeFilter);
    }

    private HttpSecurity addFilterAtOffsetOf(Filter filter, int offset, Class<? extends Filter> registeredFilter) {
        int order = this.filterOrders.getOrder(registeredFilter) + offset;
        this.filters.add(new OrderedFilter(filter, order));
        this.filterOrders.put(filter.getClass(), order);
        return this;
    }

    @Override
    public HttpSecurity addFilter(Filter filter) {
        Integer order = this.filterOrders.getOrder(filter.getClass());
        if (order == null) {
            throw new IllegalArgumentException("The Filter class " + filter.getClass().getName() + " does not have a registered order and cannot be added without a specified order. Consider using addFilterBefore or addFilterAfter instead.");
        }
        this.filters.add(new OrderedFilter(filter, order));
        return this;
    }

    public HttpSecurity addFilterAt(Filter filter, Class<? extends Filter> atFilter) {
        return this.addFilterAtOffsetOf(filter, 0, atFilter);
    }

    public RequestMatcherConfigurer securityMatchers() {
        return this.requestMatcherConfigurer;
    }

    public HttpSecurity securityMatchers(Customizer<RequestMatcherConfigurer> requestMatcherCustomizer) {
        requestMatcherCustomizer.customize(this.requestMatcherConfigurer);
        return this;
    }

    public HttpSecurity securityMatcher(RequestMatcher requestMatcher) {
        this.requestMatcher = requestMatcher;
        return this;
    }

    public HttpSecurity securityMatcher(String ... patterns) {
        if (mvcPresent) {
            this.requestMatcher = new OrRequestMatcher(this.createMvcMatchers(patterns));
            return this;
        }
        this.requestMatcher = new OrRequestMatcher(this.createAntMatchers(patterns));
        return this;
    }

    private List<RequestMatcher> createAntMatchers(String ... patterns) {
        ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>(patterns.length);
        for (String pattern : patterns) {
            matchers.add((RequestMatcher)new AntPathRequestMatcher(pattern));
        }
        return matchers;
    }

    private List<RequestMatcher> createMvcMatchers(String ... mvcPatterns) {
        ObjectPostProcessor opp = (ObjectPostProcessor)this.getContext().getBean(ObjectPostProcessor.class);
        if (!this.getContext().containsBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME)) {
            throw new NoSuchBeanDefinitionException("A Bean named mvcHandlerMappingIntrospector of type " + HandlerMappingIntrospector.class.getName() + " is required to use MvcRequestMatcher. Please ensure Spring Security & Spring MVC are configured in a shared ApplicationContext.");
        }
        HandlerMappingIntrospector introspector = (HandlerMappingIntrospector)this.getContext().getBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME, HandlerMappingIntrospector.class);
        ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>(mvcPatterns.length);
        for (String mvcPattern : mvcPatterns) {
            MvcRequestMatcher matcher = new MvcRequestMatcher(introspector, mvcPattern);
            opp.postProcess(matcher);
            matchers.add((RequestMatcher)matcher);
        }
        return matchers;
    }

    private <C extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity>> C getOrApply(C configurer) throws Exception {
        SecurityConfigurerAdapter existingConfig = (SecurityConfigurerAdapter)this.getConfigurer(configurer.getClass());
        if (existingConfig != null) {
            return (C)existingConfig;
        }
        return this.apply(configurer);
    }

    private ObservationRegistry getObservationRegistry() {
        ApplicationContext context = this.getContext();
        String[] names = context.getBeanNamesForType(ObservationRegistry.class);
        if (names.length == 1) {
            return (ObservationRegistry)context.getBean(names[0]);
        }
        return ObservationRegistry.NOOP;
    }

    public class RequestMatcherConfigurer
    extends AbstractRequestMatcherRegistry<RequestMatcherConfigurer> {
        protected List<RequestMatcher> matchers = new ArrayList<RequestMatcher>();

        RequestMatcherConfigurer(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        @Override
        protected RequestMatcherConfigurer chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            this.setMatchers(requestMatchers);
            return this;
        }

        private void setMatchers(List<? extends RequestMatcher> requestMatchers) {
            this.matchers.addAll(requestMatchers);
            HttpSecurity.this.securityMatcher((RequestMatcher)new OrRequestMatcher(this.matchers));
        }

        public HttpSecurity and() {
            return HttpSecurity.this;
        }
    }

    private static final class OrderedFilter
    implements Ordered,
    Filter {
        private final Filter filter;
        private final int order;

        private OrderedFilter(Filter filter, int order) {
            this.filter = filter;
            this.order = order;
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            this.filter.doFilter(servletRequest, servletResponse, filterChain);
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return "OrderedFilter{filter=" + this.filter + ", order=" + this.order + "}";
        }
    }
}

