/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.access.intercept.RequestMatcherDelegatingAuthorizationManager;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class AuthorizeHttpRequestsConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<AuthorizeHttpRequestsConfigurer<H>, H> {
    static final AuthorizationManager<RequestAuthorizationContext> permitAllAuthorizationManager = (a, o) -> new AuthorizationDecision(true);
    private final AuthorizationManagerRequestMatcherRegistry registry;

    public AuthorizeHttpRequestsConfigurer(ApplicationContext context) {
        this.registry = new AuthorizationManagerRequestMatcherRegistry(context);
    }

    public AuthorizationManagerRequestMatcherRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void configure(H http) {
        AuthorizationManager authorizationManager = this.registry.createAuthorizationManager();
        AuthorizationFilter authorizationFilter = new AuthorizationFilter(authorizationManager);
        http.addFilter((Filter)this.postProcess(authorizationFilter));
    }

    private AuthorizationManagerRequestMatcherRegistry addMapping(List<? extends RequestMatcher> matchers, AuthorizationManager<RequestAuthorizationContext> manager) {
        for (RequestMatcher requestMatcher : matchers) {
            this.registry.addMapping(requestMatcher, (AuthorizationManager<RequestAuthorizationContext>)manager);
        }
        return this.registry;
    }

    AuthorizationManagerRequestMatcherRegistry addFirst(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
        this.registry.addFirst(matcher, (AuthorizationManager<RequestAuthorizationContext>)manager);
        return this.registry;
    }

    public class AuthorizedUrl {
        private final List<? extends RequestMatcher> matchers;

        AuthorizedUrl(List<? extends RequestMatcher> matchers) {
            this.matchers = matchers;
        }

        protected List<? extends RequestMatcher> getMatchers() {
            return this.matchers;
        }

        public AuthorizationManagerRequestMatcherRegistry permitAll() {
            return this.access(permitAllAuthorizationManager);
        }

        public AuthorizationManagerRequestMatcherRegistry denyAll() {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)((AuthorizationManager)(a, o) -> new AuthorizationDecision(false)));
        }

        public AuthorizationManagerRequestMatcherRegistry hasRole(String role) {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasRole((String)role));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAnyRole(String ... roles) {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasAnyRole((String[])roles));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAuthority(String authority) {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasAuthority((String)authority));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAnyAuthority(String ... authorities) {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)AuthorityAuthorizationManager.hasAnyAuthority((String[])authorities));
        }

        public AuthorizationManagerRequestMatcherRegistry authenticated() {
            return this.access((AuthorizationManager<RequestAuthorizationContext>)AuthenticatedAuthorizationManager.authenticated());
        }

        public AuthorizationManagerRequestMatcherRegistry access(AuthorizationManager<RequestAuthorizationContext> manager) {
            Assert.notNull(manager, (String)"manager cannot be null");
            return AuthorizeHttpRequestsConfigurer.this.addMapping(this.matchers, (AuthorizationManager<RequestAuthorizationContext>)manager);
        }
    }

    public final class MvcMatchersAuthorizedUrl
    extends AuthorizedUrl {
        private MvcMatchersAuthorizedUrl(List<MvcRequestMatcher> matchers) {
            super(matchers);
        }

        public MvcMatchersAuthorizedUrl servletPath(String servletPath) {
            for (MvcRequestMatcher mvcRequestMatcher : this.getMatchers()) {
                mvcRequestMatcher.setServletPath(servletPath);
            }
            return this;
        }
    }

    public final class AuthorizationManagerRequestMatcherRegistry
    extends AbstractRequestMatcherRegistry<AuthorizedUrl> {
        private final RequestMatcherDelegatingAuthorizationManager.Builder managerBuilder = RequestMatcherDelegatingAuthorizationManager.builder();
        private List<RequestMatcher> unmappedMatchers;
        private int mappingCount;

        private AuthorizationManagerRequestMatcherRegistry(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        private void addMapping(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
            this.unmappedMatchers = null;
            this.managerBuilder.add(matcher, manager);
            ++this.mappingCount;
        }

        private void addFirst(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
            this.unmappedMatchers = null;
            this.managerBuilder.mappings(m -> {
                LinkedHashMap<RequestMatcher, AuthorizationManager> reorderedMap = new LinkedHashMap<RequestMatcher, AuthorizationManager>(m.size() + 1);
                reorderedMap.put(matcher, manager);
                reorderedMap.putAll((Map<RequestMatcher, AuthorizationManager>)m);
                m.clear();
                m.putAll(reorderedMap);
            });
            ++this.mappingCount;
        }

        private AuthorizationManager<HttpServletRequest> createAuthorizationManager() {
            Assert.state((this.unmappedMatchers == null ? 1 : 0) != 0, () -> "An incomplete mapping was found for " + this.unmappedMatchers + ". Try completing it with something like requestUrls().<something>.hasRole('USER')");
            Assert.state((this.mappingCount > 0 ? 1 : 0) != 0, (String)"At least one mapping is required (for example, authorizeHttpRequests().anyRequest().authenticated())");
            return (AuthorizationManager)AuthorizeHttpRequestsConfigurer.this.postProcess(this.managerBuilder.build());
        }

        @Override
        public MvcMatchersAuthorizedUrl mvcMatchers(String ... mvcPatterns) {
            return this.mvcMatchers((HttpMethod)null, mvcPatterns);
        }

        @Override
        public MvcMatchersAuthorizedUrl mvcMatchers(HttpMethod method, String ... mvcPatterns) {
            return new MvcMatchersAuthorizedUrl(this.createMvcMatchers(method, mvcPatterns));
        }

        @Override
        protected AuthorizedUrl chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            this.unmappedMatchers = requestMatchers;
            return new AuthorizedUrl(requestMatchers);
        }

        public AuthorizationManagerRequestMatcherRegistry withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
            AuthorizeHttpRequestsConfigurer.this.addObjectPostProcessor(objectPostProcessor);
            return this;
        }

        public H and() {
            return (HttpSecurityBuilder)AuthorizeHttpRequestsConfigurer.this.and();
        }
    }
}

