/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.authentication.AbstractUserDetailsServiceBeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JdbcUserServiceBeanDefinitionParser
extends AbstractUserDetailsServiceBeanDefinitionParser {
    static final String ATT_DATA_SOURCE = "data-source-ref";
    static final String ATT_USERS_BY_USERNAME_QUERY = "users-by-username-query";
    static final String ATT_AUTHORITIES_BY_USERNAME_QUERY = "authorities-by-username-query";
    static final String ATT_GROUP_AUTHORITIES_QUERY = "group-authorities-by-username-query";
    static final String ATT_ROLE_PREFIX = "role-prefix";

    @Override
    protected String getBeanClassName(Element element) {
        return "org.springframework.security.provisioning.JdbcUserDetailsManager";
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String dataSource = element.getAttribute(ATT_DATA_SOURCE);
        if (dataSource != null) {
            builder.addPropertyReference("dataSource", dataSource);
        } else {
            parserContext.getReaderContext().error("data-source-ref is required for jdbc-user-service", parserContext.extractSource((Object)element));
        }
        String usersQuery = element.getAttribute(ATT_USERS_BY_USERNAME_QUERY);
        String authoritiesQuery = element.getAttribute(ATT_AUTHORITIES_BY_USERNAME_QUERY);
        String groupAuthoritiesQuery = element.getAttribute(ATT_GROUP_AUTHORITIES_QUERY);
        String rolePrefix = element.getAttribute(ATT_ROLE_PREFIX);
        if (StringUtils.hasText((String)rolePrefix)) {
            builder.addPropertyValue("rolePrefix", (Object)rolePrefix);
        }
        if (StringUtils.hasText((String)usersQuery)) {
            builder.addPropertyValue("usersByUsernameQuery", (Object)usersQuery);
        }
        if (StringUtils.hasText((String)authoritiesQuery)) {
            builder.addPropertyValue("authoritiesByUsernameQuery", (Object)authoritiesQuery);
        }
        if (StringUtils.hasText((String)groupAuthoritiesQuery)) {
            builder.addPropertyValue("enableGroups", (Object)Boolean.TRUE);
            builder.addPropertyValue("groupAuthoritiesByUsernameQuery", (Object)groupAuthoritiesQuery);
        }
    }
}

