/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

class RequestRejectedHandlerPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private final String beanName;
    private final String targetBeanName;
    private final String targetPropertyName;

    RequestRejectedHandlerPostProcessor(String beanName, String targetBeanName, String targetPropertyName) {
        this.beanName = beanName;
        this.targetBeanName = targetBeanName;
        this.targetPropertyName = targetPropertyName;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (registry.containsBeanDefinition(this.beanName)) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(this.targetBeanName);
            beanDefinition.getPropertyValues().add(this.targetPropertyName, (Object)new RuntimeBeanReference(this.beanName));
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

