/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.saml2;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlAuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlAuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.servlet.filter.Saml2WebSsoAuthenticationFilter;
import org.springframework.security.saml2.provider.service.servlet.filter.Saml2WebSsoAuthenticationRequestFilter;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.DefaultSaml2AuthenticationRequestContextResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestContextResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationTokenConverter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class Saml2LoginConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractAuthenticationFilterConfigurer<B, Saml2LoginConfigurer<B>, Saml2WebSsoAuthenticationFilter> {
    private String loginPage;
    private String loginProcessingUrl = "/login/saml2/sso/{registrationId}";
    private AuthenticationRequestEndpointConfig authenticationRequestEndpoint = new AuthenticationRequestEndpointConfig();
    private RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private AuthenticationConverter authenticationConverter;
    private AuthenticationManager authenticationManager;
    private Saml2WebSsoAuthenticationFilter saml2WebSsoAuthenticationFilter;

    public Saml2LoginConfigurer<B> authenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
        return this;
    }

    public Saml2LoginConfigurer<B> authenticationManager(AuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
        return this;
    }

    public Saml2LoginConfigurer relyingPartyRegistrationRepository(RelyingPartyRegistrationRepository repo) {
        this.relyingPartyRegistrationRepository = repo;
        return this;
    }

    @Override
    public Saml2LoginConfigurer<B> loginPage(String loginPage) {
        Assert.hasText((String)loginPage, (String)"loginPage cannot be empty");
        this.loginPage = loginPage;
        return this;
    }

    @Override
    public Saml2LoginConfigurer<B> loginProcessingUrl(String loginProcessingUrl) {
        Assert.hasText((String)loginProcessingUrl, (String)"loginProcessingUrl cannot be empty");
        Assert.state((boolean)loginProcessingUrl.contains("{registrationId}"), (String)"{registrationId} path variable is required");
        this.loginProcessingUrl = loginProcessingUrl;
        return this;
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return new AntPathRequestMatcher(loginProcessingUrl);
    }

    @Override
    public void init(B http) throws Exception {
        this.registerDefaultCsrfOverride(http);
        if (this.relyingPartyRegistrationRepository == null) {
            this.relyingPartyRegistrationRepository = this.getSharedOrBean(http, RelyingPartyRegistrationRepository.class);
        }
        this.saml2WebSsoAuthenticationFilter = new Saml2WebSsoAuthenticationFilter(this.getAuthenticationConverter(http), this.loginProcessingUrl);
        this.setAuthenticationFilter(this.saml2WebSsoAuthenticationFilter);
        super.loginProcessingUrl(this.loginProcessingUrl);
        if (StringUtils.hasText((String)this.loginPage)) {
            super.loginPage(this.loginPage);
            super.init(http);
        } else {
            boolean singleProvider;
            Map<String, String> providerUrlMap = this.getIdentityProviderUrlMap(this.authenticationRequestEndpoint.filterProcessingUrl, this.relyingPartyRegistrationRepository);
            boolean bl = singleProvider = providerUrlMap.size() == 1;
            if (singleProvider) {
                this.updateAuthenticationDefaults();
                this.updateAccessDefaults(http);
                String loginUrl = providerUrlMap.entrySet().iterator().next().getKey();
                LoginUrlAuthenticationEntryPoint entryPoint = new LoginUrlAuthenticationEntryPoint(loginUrl);
                this.registerAuthenticationEntryPoint(http, (AuthenticationEntryPoint)entryPoint);
            } else {
                super.init(http);
            }
        }
        this.initDefaultLoginFilter(http);
    }

    @Override
    public void configure(B http) throws Exception {
        http.addFilter(this.authenticationRequestEndpoint.build(http));
        super.configure(http);
        if (this.authenticationManager == null) {
            this.registerDefaultAuthenticationProvider(http);
        } else {
            this.saml2WebSsoAuthenticationFilter.setAuthenticationManager(this.authenticationManager);
        }
    }

    private AuthenticationConverter getAuthenticationConverter(B http) {
        if (this.authenticationConverter == null) {
            return new Saml2AuthenticationTokenConverter((Converter)new DefaultRelyingPartyRegistrationResolver(this.relyingPartyRegistrationRepository));
        }
        return this.authenticationConverter;
    }

    private void registerDefaultAuthenticationProvider(B http) {
        OpenSamlAuthenticationProvider provider = this.postProcess(new OpenSamlAuthenticationProvider());
        http.authenticationProvider((AuthenticationProvider)provider);
    }

    private void registerDefaultCsrfOverride(B http) {
        CsrfConfigurer csrf = http.getConfigurer(CsrfConfigurer.class);
        if (csrf == null) {
            return;
        }
        csrf.ignoringRequestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(this.loginProcessingUrl)});
    }

    private void initDefaultLoginFilter(B http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter == null || this.isCustomLoginPage()) {
            return;
        }
        loginPageGeneratingFilter.setSaml2LoginEnabled(true);
        loginPageGeneratingFilter.setSaml2AuthenticationUrlToProviderName(this.getIdentityProviderUrlMap(this.authenticationRequestEndpoint.filterProcessingUrl, this.relyingPartyRegistrationRepository));
        loginPageGeneratingFilter.setLoginPageUrl(this.getLoginPage());
        loginPageGeneratingFilter.setFailureUrl(this.getFailureUrl());
    }

    private Map<String, String> getIdentityProviderUrlMap(String authRequestPrefixUrl, RelyingPartyRegistrationRepository idpRepo) {
        LinkedHashMap<String, String> idps = new LinkedHashMap<String, String>();
        if (idpRepo instanceof Iterable) {
            Iterable repo = (Iterable)idpRepo;
            repo.forEach(p -> idps.put(authRequestPrefixUrl.replace("{registrationId}", p.getRegistrationId()), p.getRegistrationId()));
        }
        return idps;
    }

    private <C> C getSharedOrBean(B http, Class<C> clazz) {
        C shared = http.getSharedObject(clazz);
        if (shared != null) {
            return shared;
        }
        return this.getBeanOrNull(http, clazz);
    }

    private <C> C getBeanOrNull(B http, Class<C> clazz) {
        ApplicationContext context = http.getSharedObject(ApplicationContext.class);
        if (context == null) {
            return null;
        }
        try {
            return (C)context.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return null;
        }
    }

    private <C> void setSharedObject(B http, Class<C> clazz, C object) {
        if (http.getSharedObject(clazz) == null) {
            http.setSharedObject(clazz, object);
        }
    }

    private final class AuthenticationRequestEndpointConfig {
        private String filterProcessingUrl = "/saml2/authenticate/{registrationId}";

        private AuthenticationRequestEndpointConfig() {
        }

        private Filter build(B http) {
            Saml2AuthenticationRequestFactory authenticationRequestResolver = this.getResolver(http);
            Saml2AuthenticationRequestContextResolver contextResolver = this.getContextResolver(http);
            return (Filter)Saml2LoginConfigurer.this.postProcess(new Saml2WebSsoAuthenticationRequestFilter(contextResolver, authenticationRequestResolver));
        }

        private Saml2AuthenticationRequestFactory getResolver(B http) {
            Saml2AuthenticationRequestFactory resolver = (Saml2AuthenticationRequestFactory)Saml2LoginConfigurer.this.getSharedOrBean(http, Saml2AuthenticationRequestFactory.class);
            if (resolver == null) {
                resolver = new OpenSamlAuthenticationRequestFactory();
            }
            return resolver;
        }

        private Saml2AuthenticationRequestContextResolver getContextResolver(B http) {
            Saml2AuthenticationRequestContextResolver resolver = (Saml2AuthenticationRequestContextResolver)Saml2LoginConfigurer.this.getBeanOrNull(http, Saml2AuthenticationRequestContextResolver.class);
            if (resolver == null) {
                return new DefaultSaml2AuthenticationRequestContextResolver((Converter)new DefaultRelyingPartyRegistrationResolver(Saml2LoginConfigurer.this.relyingPartyRegistrationRepository));
            }
            return resolver;
        }
    }
}

