/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.rsocket;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authorization.AuthenticatedReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorityReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtReactiveAuthenticationManager;
import org.springframework.security.rsocket.PayloadInterceptor;
import org.springframework.security.rsocket.PayloadSocketAcceptorInterceptor;
import org.springframework.security.rsocket.authentication.AnonymousPayloadInterceptor;
import org.springframework.security.rsocket.authentication.AuthenticationPayloadInterceptor;
import org.springframework.security.rsocket.authentication.BearerPayloadExchangeConverter;
import org.springframework.security.rsocket.authentication.PayloadExchangeAuthenticationConverter;
import org.springframework.security.rsocket.authorization.AuthorizationPayloadInterceptor;
import org.springframework.security.rsocket.authorization.PayloadExchangeMatcherReactiveAuthorizationManager;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeAuthorizationContext;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeMatcher;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeMatcherEntry;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeMatchers;
import org.springframework.security.rsocket.util.matcher.RoutePayloadExchangeMatcher;
import reactor.core.publisher.Mono;

public class RSocketSecurity {
    private BasicAuthenticationSpec basicAuthSpec;
    private JwtSpec jwtSpec;
    private AuthorizePayloadsSpec authorizePayload;
    private ApplicationContext context;
    private ReactiveAuthenticationManager authenticationManager;

    public RSocketSecurity authenticationManager(ReactiveAuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
        return this;
    }

    public RSocketSecurity basicAuthentication(Customizer<BasicAuthenticationSpec> basic) {
        if (this.basicAuthSpec == null) {
            this.basicAuthSpec = new BasicAuthenticationSpec();
        }
        basic.customize(this.basicAuthSpec);
        return this;
    }

    public RSocketSecurity jwt(Customizer<JwtSpec> jwt) {
        if (this.jwtSpec == null) {
            this.jwtSpec = new JwtSpec();
        }
        jwt.customize(this.jwtSpec);
        return this;
    }

    public RSocketSecurity authorizePayload(Customizer<AuthorizePayloadsSpec> authorize) {
        if (this.authorizePayload == null) {
            this.authorizePayload = new AuthorizePayloadsSpec();
        }
        authorize.customize(this.authorizePayload);
        return this;
    }

    public PayloadSocketAcceptorInterceptor build() {
        PayloadSocketAcceptorInterceptor interceptor = new PayloadSocketAcceptorInterceptor(this.payloadInterceptors());
        RSocketMessageHandler handler = this.getBean(RSocketMessageHandler.class);
        interceptor.setDefaultDataMimeType(handler.getDefaultDataMimeType());
        interceptor.setDefaultMetadataMimeType(handler.getDefaultMetadataMimeType());
        return interceptor;
    }

    private List<PayloadInterceptor> payloadInterceptors() {
        ArrayList<PayloadInterceptor> payloadInterceptors = new ArrayList<PayloadInterceptor>();
        if (this.basicAuthSpec != null) {
            payloadInterceptors.add((PayloadInterceptor)this.basicAuthSpec.build());
        }
        if (this.jwtSpec != null) {
            payloadInterceptors.add((PayloadInterceptor)this.jwtSpec.build());
        }
        payloadInterceptors.add((PayloadInterceptor)new AnonymousPayloadInterceptor("anonymousUser"));
        if (this.authorizePayload != null) {
            payloadInterceptors.add((PayloadInterceptor)this.authorizePayload.build());
        }
        return payloadInterceptors;
    }

    private <T> T getBean(Class<T> beanClass) {
        if (this.context == null) {
            return null;
        }
        return (T)this.context.getBean(beanClass);
    }

    private <T> T getBeanOrNull(Class<T> beanClass) {
        return this.getBeanOrNull(ResolvableType.forClass(beanClass));
    }

    private <T> T getBeanOrNull(ResolvableType type) {
        if (this.context == null) {
            return null;
        }
        String[] names = this.context.getBeanNamesForType(type);
        if (names.length == 1) {
            return (T)this.context.getBean(names[0]);
        }
        return null;
    }

    protected void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public class AuthorizePayloadsSpec {
        private PayloadExchangeMatcherReactiveAuthorizationManager.Builder authzBuilder = PayloadExchangeMatcherReactiveAuthorizationManager.builder();

        public Access setup() {
            return this.matcher(PayloadExchangeMatchers.setup());
        }

        public Access anyRequest() {
            return this.matcher(PayloadExchangeMatchers.anyExchange());
        }

        protected AuthorizationPayloadInterceptor build() {
            return new AuthorizationPayloadInterceptor((ReactiveAuthorizationManager)this.authzBuilder.build());
        }

        public Access route(String pattern) {
            RSocketMessageHandler handler = (RSocketMessageHandler)RSocketSecurity.this.getBean(RSocketMessageHandler.class);
            RoutePayloadExchangeMatcher matcher = new RoutePayloadExchangeMatcher(handler.getMetadataExtractor(), handler.getRouteMatcher(), pattern);
            return this.matcher((PayloadExchangeMatcher)matcher);
        }

        public Access matcher(PayloadExchangeMatcher matcher) {
            return new Access(matcher);
        }

        public class Access {
            private final PayloadExchangeMatcher matcher;

            private Access(PayloadExchangeMatcher matcher) {
                this.matcher = matcher;
            }

            public AuthorizePayloadsSpec authenticated() {
                return this.access((ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>)AuthenticatedReactiveAuthorizationManager.authenticated());
            }

            public AuthorizePayloadsSpec hasRole(String role) {
                return this.access((ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>)AuthorityReactiveAuthorizationManager.hasRole((String)role));
            }

            public AuthorizePayloadsSpec permitAll() {
                return this.access((ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext>)((ReactiveAuthorizationManager)(a, ctx) -> Mono.just((Object)new AuthorizationDecision(true))));
            }

            public AuthorizePayloadsSpec access(ReactiveAuthorizationManager<PayloadExchangeAuthorizationContext> authorization) {
                AuthorizePayloadsSpec.this.authzBuilder.add(new PayloadExchangeMatcherEntry(this.matcher, authorization));
                return AuthorizePayloadsSpec.this;
            }
        }
    }

    public class JwtSpec {
        private ReactiveAuthenticationManager authenticationManager;

        public JwtSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        private ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager != null) {
                return this.authenticationManager;
            }
            ReactiveJwtDecoder jwtDecoder = (ReactiveJwtDecoder)RSocketSecurity.this.getBeanOrNull(ReactiveJwtDecoder.class);
            if (jwtDecoder != null) {
                this.authenticationManager = new JwtReactiveAuthenticationManager(jwtDecoder);
                return this.authenticationManager;
            }
            return RSocketSecurity.this.authenticationManager;
        }

        protected AuthenticationPayloadInterceptor build() {
            ReactiveAuthenticationManager manager = this.getAuthenticationManager();
            AuthenticationPayloadInterceptor result = new AuthenticationPayloadInterceptor(manager);
            result.setAuthenticationConverter((PayloadExchangeAuthenticationConverter)new BearerPayloadExchangeConverter());
            return result;
        }

        private JwtSpec() {
        }
    }

    public class BasicAuthenticationSpec {
        private ReactiveAuthenticationManager authenticationManager;

        public BasicAuthenticationSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        private ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager == null) {
                return RSocketSecurity.this.authenticationManager;
            }
            return this.authenticationManager;
        }

        protected AuthenticationPayloadInterceptor build() {
            ReactiveAuthenticationManager manager = this.getAuthenticationManager();
            return new AuthenticationPayloadInterceptor(manager);
        }

        private BasicAuthenticationSpec() {
        }
    }
}

