/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.EnableGlobalAuthentication;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.configuration.InitializeAuthenticationProviderBeanManagerConfigurer;
import org.springframework.security.config.annotation.authentication.configuration.InitializeUserDetailsBeanManagerConfigurer;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.JdbcUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.authentication.configurers.userdetails.DaoAuthenticationConfigurer;
import org.springframework.security.config.annotation.configuration.ObjectPostProcessorConfiguration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@Import(value={ObjectPostProcessorConfiguration.class})
public class AuthenticationConfiguration {
    private AtomicBoolean buildingAuthenticationManager = new AtomicBoolean();
    private ApplicationContext applicationContext;
    private AuthenticationManager authenticationManager;
    private boolean authenticationManagerInitialized;
    private List<GlobalAuthenticationConfigurerAdapter> globalAuthConfigurers = Collections.emptyList();
    private ObjectPostProcessor<Object> objectPostProcessor;

    @Bean
    public AuthenticationManagerBuilder authenticationManagerBuilder(ObjectPostProcessor<Object> objectPostProcessor, ApplicationContext context) {
        LazyPasswordEncoder defaultPasswordEncoder = new LazyPasswordEncoder(context);
        AuthenticationEventPublisher authenticationEventPublisher = AuthenticationConfiguration.getBeanOrNull(context, AuthenticationEventPublisher.class);
        DefaultPasswordEncoderAuthenticationManagerBuilder result = new DefaultPasswordEncoderAuthenticationManagerBuilder(objectPostProcessor, defaultPasswordEncoder);
        if (authenticationEventPublisher != null) {
            result.authenticationEventPublisher(authenticationEventPublisher);
        }
        return result;
    }

    @Bean
    public static GlobalAuthenticationConfigurerAdapter enableGlobalAuthenticationAutowiredConfigurer(ApplicationContext context) {
        return new EnableGlobalAuthenticationAutowiredConfigurer(context);
    }

    @Bean
    public static InitializeUserDetailsBeanManagerConfigurer initializeUserDetailsBeanManagerConfigurer(ApplicationContext context) {
        return new InitializeUserDetailsBeanManagerConfigurer(context);
    }

    @Bean
    public static InitializeAuthenticationProviderBeanManagerConfigurer initializeAuthenticationProviderBeanManagerConfigurer(ApplicationContext context) {
        return new InitializeAuthenticationProviderBeanManagerConfigurer(context);
    }

    public AuthenticationManager getAuthenticationManager() throws Exception {
        if (this.authenticationManagerInitialized) {
            return this.authenticationManager;
        }
        AuthenticationManagerBuilder authBuilder = (AuthenticationManagerBuilder)this.applicationContext.getBean(AuthenticationManagerBuilder.class);
        if (this.buildingAuthenticationManager.getAndSet(true)) {
            return new AuthenticationManagerDelegator(authBuilder);
        }
        for (GlobalAuthenticationConfigurerAdapter config : this.globalAuthConfigurers) {
            authBuilder.apply(config);
        }
        this.authenticationManager = (AuthenticationManager)authBuilder.build();
        if (this.authenticationManager == null) {
            this.authenticationManager = this.getAuthenticationManagerBean();
        }
        this.authenticationManagerInitialized = true;
        return this.authenticationManager;
    }

    @Autowired(required=false)
    public void setGlobalAuthenticationConfigurers(List<GlobalAuthenticationConfigurerAdapter> configurers) throws Exception {
        configurers.sort((Comparator<GlobalAuthenticationConfigurerAdapter>)AnnotationAwareOrderComparator.INSTANCE);
        this.globalAuthConfigurers = configurers;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Autowired
    public void setObjectPostProcessor(ObjectPostProcessor<Object> objectPostProcessor) {
        this.objectPostProcessor = objectPostProcessor;
    }

    private <T> T lazyBean(Class<T> interfaceName) {
        String beanName;
        LazyInitTargetSource lazyTargetSource = new LazyInitTargetSource();
        String[] beanNamesForType = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, interfaceName);
        if (beanNamesForType.length == 0) {
            return null;
        }
        if (beanNamesForType.length > 1) {
            List<String> primaryBeanNames = this.getPrimaryBeanNames(beanNamesForType);
            Assert.isTrue((primaryBeanNames.size() != 0 ? 1 : 0) != 0, () -> "Found " + beanNamesForType.length + " beans for type " + interfaceName + ", but none marked as primary");
            Assert.isTrue((primaryBeanNames.size() == 1 ? 1 : 0) != 0, () -> "Found " + primaryBeanNames.size() + " beans for type " + interfaceName + " marked as primary");
            beanName = primaryBeanNames.get(0);
        } else {
            beanName = beanNamesForType[0];
        }
        lazyTargetSource.setTargetBeanName(beanName);
        lazyTargetSource.setBeanFactory((BeanFactory)this.applicationContext);
        ProxyFactoryBean proxyFactory = new ProxyFactoryBean();
        proxyFactory = this.objectPostProcessor.postProcess(proxyFactory);
        proxyFactory.setTargetSource((TargetSource)lazyTargetSource);
        return (T)proxyFactory.getObject();
    }

    private List<String> getPrimaryBeanNames(String[] beanNamesForType) {
        ArrayList<String> list = new ArrayList<String>();
        if (!(this.applicationContext instanceof ConfigurableApplicationContext)) {
            return Collections.emptyList();
        }
        for (String beanName : beanNamesForType) {
            if (!((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().getBeanDefinition(beanName).isPrimary()) continue;
            list.add(beanName);
        }
        return list;
    }

    private AuthenticationManager getAuthenticationManagerBean() {
        return this.lazyBean(AuthenticationManager.class);
    }

    private static <T> T getBeanOrNull(ApplicationContext applicationContext, Class<T> type) {
        try {
            return (T)applicationContext.getBean(type);
        }
        catch (NoSuchBeanDefinitionException notFound) {
            return null;
        }
    }

    static class LazyPasswordEncoder
    implements PasswordEncoder {
        private ApplicationContext applicationContext;
        private PasswordEncoder passwordEncoder;

        LazyPasswordEncoder(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        public String encode(CharSequence rawPassword) {
            return this.getPasswordEncoder().encode(rawPassword);
        }

        public boolean matches(CharSequence rawPassword, String encodedPassword) {
            return this.getPasswordEncoder().matches(rawPassword, encodedPassword);
        }

        public boolean upgradeEncoding(String encodedPassword) {
            return this.getPasswordEncoder().upgradeEncoding(encodedPassword);
        }

        private PasswordEncoder getPasswordEncoder() {
            if (this.passwordEncoder != null) {
                return this.passwordEncoder;
            }
            PasswordEncoder passwordEncoder = (PasswordEncoder)AuthenticationConfiguration.getBeanOrNull(this.applicationContext, PasswordEncoder.class);
            if (passwordEncoder == null) {
                passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
            }
            this.passwordEncoder = passwordEncoder;
            return passwordEncoder;
        }

        public String toString() {
            return this.getPasswordEncoder().toString();
        }
    }

    static class DefaultPasswordEncoderAuthenticationManagerBuilder
    extends AuthenticationManagerBuilder {
        private PasswordEncoder defaultPasswordEncoder;

        DefaultPasswordEncoderAuthenticationManagerBuilder(ObjectPostProcessor<Object> objectPostProcessor, PasswordEncoder defaultPasswordEncoder) {
            super(objectPostProcessor);
            this.defaultPasswordEncoder = defaultPasswordEncoder;
        }

        @Override
        public InMemoryUserDetailsManagerConfigurer<AuthenticationManagerBuilder> inMemoryAuthentication() throws Exception {
            return (InMemoryUserDetailsManagerConfigurer)super.inMemoryAuthentication().passwordEncoder(this.defaultPasswordEncoder);
        }

        @Override
        public JdbcUserDetailsManagerConfigurer<AuthenticationManagerBuilder> jdbcAuthentication() throws Exception {
            return (JdbcUserDetailsManagerConfigurer)super.jdbcAuthentication().passwordEncoder(this.defaultPasswordEncoder);
        }

        @Override
        public <T extends UserDetailsService> DaoAuthenticationConfigurer<AuthenticationManagerBuilder, T> userDetailsService(T userDetailsService) throws Exception {
            return (DaoAuthenticationConfigurer)super.userDetailsService(userDetailsService).passwordEncoder(this.defaultPasswordEncoder);
        }
    }

    static final class AuthenticationManagerDelegator
    implements AuthenticationManager {
        private AuthenticationManagerBuilder delegateBuilder;
        private AuthenticationManager delegate;
        private final Object delegateMonitor = new Object();

        AuthenticationManagerDelegator(AuthenticationManagerBuilder delegateBuilder) {
            Assert.notNull((Object)delegateBuilder, (String)"delegateBuilder cannot be null");
            this.delegateBuilder = delegateBuilder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            if (this.delegate != null) {
                return this.delegate.authenticate(authentication);
            }
            Object object = this.delegateMonitor;
            synchronized (object) {
                if (this.delegate == null) {
                    this.delegate = (AuthenticationManager)this.delegateBuilder.getObject();
                    this.delegateBuilder = null;
                }
            }
            return this.delegate.authenticate(authentication);
        }

        public String toString() {
            return "AuthenticationManagerDelegator [delegate=" + this.delegate + "]";
        }
    }

    private static class EnableGlobalAuthenticationAutowiredConfigurer
    extends GlobalAuthenticationConfigurerAdapter {
        private final ApplicationContext context;
        private static final Log logger = LogFactory.getLog(EnableGlobalAuthenticationAutowiredConfigurer.class);

        EnableGlobalAuthenticationAutowiredConfigurer(ApplicationContext context) {
            this.context = context;
        }

        @Override
        public void init(AuthenticationManagerBuilder auth) {
            Map beansWithAnnotation = this.context.getBeansWithAnnotation(EnableGlobalAuthentication.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Eagerly initializing " + beansWithAnnotation));
            }
        }
    }
}

