/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.messaging;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.messaging.access.expression.ExpressionBasedMessageSecurityMetadataSourceFactory;
import org.springframework.security.messaging.access.intercept.MessageSecurityMetadataSource;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.security.messaging.util.matcher.SimpDestinationMessageMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageSecurityMetadataSourceRegistry {
    private static final String permitAll = "permitAll";
    private static final String denyAll = "denyAll";
    private static final String anonymous = "anonymous";
    private static final String authenticated = "authenticated";
    private static final String fullyAuthenticated = "fullyAuthenticated";
    private static final String rememberMe = "rememberMe";
    private final LinkedHashMap<MatcherBuilder, String> matcherToExpression = new LinkedHashMap();
    private PathMatcher pathMatcher = new AntPathMatcher();

    public Constraint anyMessage() {
        return this.matchers(MessageMatcher.ANY_MESSAGE);
    }

    public Constraint destinationMatchers(String ... patterns) {
        ArrayList<PathMatcherMessageMatcherBuilder> matchers = new ArrayList<PathMatcherMessageMatcherBuilder>(patterns.length);
        for (String pattern : patterns) {
            matchers.add(new PathMatcherMessageMatcherBuilder(pattern));
        }
        return new Constraint(matchers);
    }

    public MessageSecurityMetadataSourceRegistry pathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"pathMatcher cannot be null");
        this.pathMatcher = pathMatcher;
        return this;
    }

    public Constraint matchers(MessageMatcher<?> ... matchers) {
        ArrayList<PreBuiltMatcherBuilder> builders = new ArrayList<PreBuiltMatcherBuilder>(matchers.length);
        for (MessageMatcher<?> matcher : matchers) {
            builders.add(new PreBuiltMatcherBuilder(matcher));
        }
        return new Constraint(builders);
    }

    protected MessageSecurityMetadataSource createMetadataSource() {
        LinkedHashMap matcherToExpression = new LinkedHashMap();
        for (Map.Entry<MatcherBuilder, String> entry : this.matcherToExpression.entrySet()) {
            matcherToExpression.put(entry.getKey().build(), entry.getValue());
        }
        return ExpressionBasedMessageSecurityMetadataSourceFactory.createExpressionMessageMetadataSource(matcherToExpression);
    }

    private static String hasAnyRole(String ... authorities) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)"','ROLE_");
        return "hasAnyRole('ROLE_" + anyAuthorities + "')";
    }

    private static String hasRole(String role) {
        Assert.notNull((Object)role, (String)"role cannot be null");
        if (role.startsWith("ROLE_")) {
            throw new IllegalArgumentException("role should not start with 'ROLE_' since it is automatically inserted. Got '" + role + "'");
        }
        return "hasRole('ROLE_" + role + "')";
    }

    private static String hasAuthority(String authority) {
        return "hasAuthority('" + authority + "')";
    }

    private static String hasAnyAuthority(String ... authorities) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)"','");
        return "hasAnyAuthority('" + anyAuthorities + "')";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MatcherBuilder {
        public MessageMatcher<?> build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathMatcherMessageMatcherBuilder
    implements MatcherBuilder {
        private final String pattern;

        private PathMatcherMessageMatcherBuilder(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public MessageMatcher<?> build() {
            return new SimpDestinationMessageMatcher(this.pattern, MessageSecurityMetadataSourceRegistry.this.pathMatcher);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreBuiltMatcherBuilder
    implements MatcherBuilder {
        private MessageMatcher<?> matcher;

        private PreBuiltMatcherBuilder(MessageMatcher<?> matcher) {
            this.matcher = matcher;
        }

        @Override
        public MessageMatcher<?> build() {
            return this.matcher;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Constraint {
        private final List<MatcherBuilder> messageMatchers;

        private Constraint(List<MatcherBuilder> messageMatchers) {
            Assert.notEmpty(messageMatchers, (String)"messageMatchers cannot be null or empty");
            this.messageMatchers = messageMatchers;
        }

        public MessageSecurityMetadataSourceRegistry hasRole(String role) {
            return this.access(MessageSecurityMetadataSourceRegistry.hasRole(role));
        }

        public MessageSecurityMetadataSourceRegistry hasAnyRole(String ... roles) {
            return this.access(MessageSecurityMetadataSourceRegistry.hasAnyRole(roles));
        }

        public MessageSecurityMetadataSourceRegistry hasAuthority(String authority) {
            return this.access(MessageSecurityMetadataSourceRegistry.hasAuthority(authority));
        }

        public MessageSecurityMetadataSourceRegistry hasAnyAuthority(String ... authorities) {
            return this.access(MessageSecurityMetadataSourceRegistry.hasAnyAuthority(authorities));
        }

        public MessageSecurityMetadataSourceRegistry permitAll() {
            return this.access(MessageSecurityMetadataSourceRegistry.permitAll);
        }

        public MessageSecurityMetadataSourceRegistry anonymous() {
            return this.access(MessageSecurityMetadataSourceRegistry.anonymous);
        }

        public MessageSecurityMetadataSourceRegistry rememberMe() {
            return this.access(MessageSecurityMetadataSourceRegistry.rememberMe);
        }

        public MessageSecurityMetadataSourceRegistry denyAll() {
            return this.access(MessageSecurityMetadataSourceRegistry.denyAll);
        }

        public MessageSecurityMetadataSourceRegistry authenticated() {
            return this.access(MessageSecurityMetadataSourceRegistry.authenticated);
        }

        public MessageSecurityMetadataSourceRegistry fullyAuthenticated() {
            return this.access(MessageSecurityMetadataSourceRegistry.fullyAuthenticated);
        }

        public MessageSecurityMetadataSourceRegistry access(String attribute) {
            for (MatcherBuilder messageMatcher : this.messageMatchers) {
                MessageSecurityMetadataSourceRegistry.this.matcherToExpression.put(messageMatcher, attribute);
            }
            return MessageSecurityMetadataSourceRegistry.this;
        }
    }
}

