/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.web.authentication.rememberme.JdbcTokenRepositoryImpl;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class RememberMeBeanDefinitionParser
implements BeanDefinitionParser {
    static final String ATT_DATA_SOURCE = "data-source-ref";
    static final String ATT_SERVICES_REF = "services-ref";
    static final String ATT_SERVICES_ALIAS = "services-alias";
    static final String ATT_TOKEN_REPOSITORY = "token-repository-ref";
    static final String ATT_USER_SERVICE_REF = "user-service-ref";
    static final String ATT_TOKEN_VALIDITY = "token-validity-seconds";
    static final String ATT_SECURE_COOKIE = "use-secure-cookie";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String servicesName;
    private final String key;

    RememberMeBeanDefinitionParser(String key) {
        this.key = key;
    }

    public BeanDefinition parse(Element element, ParserContext pc) {
        boolean isPersistent;
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), pc.extractSource((Object)element));
        pc.pushContainingComponent(compositeDef);
        String tokenRepository = element.getAttribute(ATT_TOKEN_REPOSITORY);
        String dataSource = element.getAttribute(ATT_DATA_SOURCE);
        String userServiceRef = element.getAttribute(ATT_USER_SERVICE_REF);
        String rememberMeServicesRef = element.getAttribute(ATT_SERVICES_REF);
        String tokenValiditySeconds = element.getAttribute(ATT_TOKEN_VALIDITY);
        Object source = pc.extractSource((Object)element);
        RootBeanDefinition services = null;
        boolean dataSourceSet = StringUtils.hasText((String)dataSource);
        boolean tokenRepoSet = StringUtils.hasText((String)tokenRepository);
        boolean servicesRefSet = StringUtils.hasText((String)rememberMeServicesRef);
        boolean userServiceSet = StringUtils.hasText((String)userServiceRef);
        boolean tokenValiditySet = StringUtils.hasText((String)tokenValiditySeconds);
        if (servicesRefSet && (dataSourceSet || tokenRepoSet || userServiceSet || tokenValiditySet)) {
            pc.getReaderContext().error("services-ref can't be used in combination with attributes token-repository-ref,data-source-ref, user-service-ref or token-validity-seconds", source);
        }
        if (dataSourceSet && tokenRepoSet) {
            pc.getReaderContext().error("Specify token-repository-ref or data-source-ref but not both", source);
        }
        if (isPersistent = dataSourceSet | tokenRepoSet) {
            RuntimeBeanReference tokenRepo;
            services = new RootBeanDefinition(PersistentTokenBasedRememberMeServices.class);
            if (tokenRepoSet) {
                tokenRepo = new RuntimeBeanReference(tokenRepository);
            } else {
                tokenRepo = new RootBeanDefinition(JdbcTokenRepositoryImpl.class);
                ((BeanDefinition)tokenRepo).getPropertyValues().addPropertyValue("dataSource", (Object)new RuntimeBeanReference(dataSource));
            }
            services.getPropertyValues().addPropertyValue("tokenRepository", (Object)tokenRepo);
        } else if (!servicesRefSet) {
            services = new RootBeanDefinition(TokenBasedRememberMeServices.class);
        }
        if (services != null) {
            if (userServiceSet) {
                services.getPropertyValues().addPropertyValue("userDetailsService", (Object)new RuntimeBeanReference(userServiceRef));
            }
            if ("true".equals(element.getAttribute(ATT_SECURE_COOKIE))) {
                services.getPropertyValues().addPropertyValue("useSecureCookie", (Object)true);
            }
            if (tokenValiditySet) {
                Integer tokenValidity = new Integer(tokenValiditySeconds);
                if (tokenValidity < 0 && isPersistent) {
                    pc.getReaderContext().error("token-validity-seconds cannot be negative if using a persistent remember-me token repository", source);
                }
                services.getPropertyValues().addPropertyValue("tokenValiditySeconds", (Object)tokenValidity);
            }
            services.setSource(source);
            services.getPropertyValues().addPropertyValue("key", (Object)this.key);
            this.servicesName = pc.getReaderContext().registerWithGeneratedName((BeanDefinition)services);
            pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)services, this.servicesName));
        } else {
            this.servicesName = rememberMeServicesRef;
        }
        if (StringUtils.hasText((String)element.getAttribute(ATT_SERVICES_ALIAS))) {
            pc.getRegistry().registerAlias(this.servicesName, element.getAttribute(ATT_SERVICES_ALIAS));
        }
        BeanDefinition filter = this.createFilter(pc, source);
        pc.popAndRegisterContainingComponent();
        return filter;
    }

    private BeanDefinition createFilter(ParserContext pc, Object source) {
        BeanDefinitionBuilder filter = BeanDefinitionBuilder.rootBeanDefinition(RememberMeAuthenticationFilter.class);
        filter.getRawBeanDefinition().setSource(source);
        filter.addPropertyReference("rememberMeServices", this.servicesName);
        return filter.getBeanDefinition();
    }
}

