/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.AbstractUserDetailsServiceBeanDefinitionParser;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.memory.UserMap;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class UserServiceBeanDefinitionParser
extends AbstractUserDetailsServiceBeanDefinitionParser {
    static final String ATT_PASSWORD = "password";
    static final String ATT_NAME = "name";
    static final String ELT_USER = "user";
    static final String ATT_AUTHORITIES = "authorities";
    static final String ATT_PROPERTIES = "properties";
    static final String ATT_DISABLED = "disabled";
    static final String ATT_LOCKED = "locked";

    protected String getBeanClassName(Element element) {
        return "org.springframework.security.core.userdetails.memory.InMemoryDaoImpl";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String userProperties = element.getAttribute(ATT_PROPERTIES);
        List userElts = DomUtils.getChildElementsByTagName((Element)element, (String)ELT_USER);
        if (StringUtils.hasText((String)userProperties)) {
            if (!CollectionUtils.isEmpty((Collection)userElts)) {
                throw new BeanDefinitionStoreException("Use of a properties file and user elements are mutually exclusive");
            }
            RootBeanDefinition bd = new RootBeanDefinition(PropertiesFactoryBean.class);
            bd.getPropertyValues().addPropertyValue("location", (Object)userProperties);
            builder.addPropertyValue("userProperties", (Object)bd);
            return;
        }
        if (CollectionUtils.isEmpty((Collection)userElts)) {
            throw new BeanDefinitionStoreException("You must supply user definitions, either with <user> child elements or a properties file (using the 'properties' attribute)");
        }
        UserMap users = new UserMap();
        for (Element userElt : userElts) {
            String userName = userElt.getAttribute(ATT_NAME);
            String password = userElt.getAttribute(ATT_PASSWORD);
            boolean locked = "true".equals(userElt.getAttribute(ATT_LOCKED));
            boolean disabled = "true".equals(userElt.getAttribute(ATT_DISABLED));
            users.addUser((UserDetails)new User(userName, password, !disabled, true, true, !locked, AuthorityUtils.commaSeparatedStringToAuthorityList((String)userElt.getAttribute(ATT_AUTHORITIES))));
        }
        builder.addPropertyValue("userMap", (Object)users);
    }
}

