/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceAuthenticationManager
extends ProviderManager
implements BeanFactoryAware {
    BeanFactory beanFactory;
    List<String> providerBeanNames;

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.providerBeanNames, (String)"provideBeanNames has not been set");
        Assert.notEmpty(this.providerBeanNames, (String)"No authentication providers were found in the application context");
        super.afterPropertiesSet();
    }

    public List<AuthenticationProvider> getProviders() {
        if (this.providerBeanNames != null) {
            ArrayList<AuthenticationProvider> providers = new ArrayList<AuthenticationProvider>();
            Iterator<String> beanNames = this.providerBeanNames.iterator();
            while (beanNames.hasNext()) {
                providers.add((AuthenticationProvider)this.beanFactory.getBean(beanNames.next()));
            }
            this.providerBeanNames = null;
            providers.trimToSize();
            this.setProviders(providers);
        }
        return super.getProviders();
    }

    public void setProviderBeanNames(List<String> provideBeanNames) {
        this.providerBeanNames = provideBeanNames;
    }
}

