/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.ConfigAttributeEditor;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.config.AnonymousBeanDefinitionParser;
import org.springframework.security.config.BasicAuthenticationBeanDefinitionParser;
import org.springframework.security.config.ConcurrentSessionsBeanDefinitionParser;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.config.EntryPointInjectionBeanPostProcessor;
import org.springframework.security.config.FormLoginBeanDefinitionParser;
import org.springframework.security.config.LogoutBeanDefinitionParser;
import org.springframework.security.config.PortMappingsBeanDefinitionParser;
import org.springframework.security.config.RememberMeBeanDefinitionParser;
import org.springframework.security.config.RememberMeServicesInjectionBeanPostProcessor;
import org.springframework.security.config.UserDetailsServiceInjectionBeanPostProcessor;
import org.springframework.security.config.X509BeanDefinitionParser;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.channel.ChannelDecisionManagerImpl;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.access.channel.InsecureChannelProcessor;
import org.springframework.security.web.access.channel.RetryWithHttpEntryPoint;
import org.springframework.security.web.access.channel.RetryWithHttpsEntryPoint;
import org.springframework.security.web.access.channel.SecureChannelProcessor;
import org.springframework.security.web.access.expression.WebExpressionVoter;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.access.intercept.RequestKey;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.session.SessionFixationProtectionFilter;
import org.springframework.security.web.util.AntUrlPathMatcher;
import org.springframework.security.web.util.RegexUrlPathMatcher;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.security.web.wrapper.SecurityContextHolderAwareRequestFilter;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Log logger = LogFactory.getLog(HttpSecurityBeanDefinitionParser.class);
    static final String ATT_PATH_PATTERN = "pattern";
    static final String ATT_PATH_TYPE = "path-type";
    static final String OPT_PATH_TYPE_REGEX = "regex";
    private static final String DEF_PATH_TYPE_ANT = "ant";
    static final String ATT_FILTERS = "filters";
    static final String OPT_FILTERS_NONE = "none";
    private static final String ATT_REALM = "realm";
    private static final String DEF_REALM = "Spring Security Application";
    private static final String ATT_SESSION_FIXATION_PROTECTION = "session-fixation-protection";
    private static final String OPT_SESSION_FIXATION_NO_PROTECTION = "none";
    private static final String OPT_SESSION_FIXATION_MIGRATE_SESSION = "migrateSession";
    private static final String ATT_ACCESS_CONFIG = "access";
    static final String ATT_REQUIRES_CHANNEL = "requires-channel";
    private static final String OPT_REQUIRES_HTTP = "http";
    private static final String OPT_REQUIRES_HTTPS = "https";
    private static final String OPT_ANY_CHANNEL = "any";
    private static final String ATT_HTTP_METHOD = "method";
    private static final String ATT_CREATE_SESSION = "create-session";
    private static final String DEF_CREATE_SESSION_IF_REQUIRED = "ifRequired";
    private static final String OPT_CREATE_SESSION_ALWAYS = "always";
    private static final String OPT_CREATE_SESSION_NEVER = "never";
    private static final String ATT_LOWERCASE_COMPARISONS = "lowercase-comparisons";
    private static final String ATT_AUTO_CONFIG = "auto-config";
    private static final String ATT_SERVLET_API_PROVISION = "servlet-api-provision";
    private static final String DEF_SERVLET_API_PROVISION = "true";
    private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";
    private static final String ATT_USER_SERVICE_REF = "user-service-ref";
    private static final String ATT_ENTRY_POINT_REF = "entry-point-ref";
    private static final String ATT_ONCE_PER_REQUEST = "once-per-request";
    private static final String ATT_ACCESS_DENIED_PAGE = "access-denied-page";
    private static final String ATT_ACCESS_DENIED_ERROR_PAGE = "error-page";
    private static final String ATT_USE_EXPRESSIONS = "use-expressions";
    private static final String ATT_SECURITY_CONTEXT_REPOSITORY = "security-context-repository-ref";
    private static final String ATT_DISABLE_URL_REWRITING = "disable-url-rewriting";
    static final String OPEN_ID_AUTHENTICATION_PROCESSING_FILTER_CLASS = "org.springframework.security.openid.OpenIDAuthenticationProcessingFilter";
    static final String OPEN_ID_AUTHENTICATION_PROVIDER_CLASS = "org.springframework.security.openid.OpenIDAuthenticationProvider";
    static final String AUTHENTICATION_PROCESSING_FILTER_CLASS = "org.springframework.security.web.authentication.UsernamePasswordAuthenticationProcessingFilter";
    static final String EXPRESSION_FIMDS_CLASS = "org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource";
    static final String EXPRESSION_HANDLER_CLASS = "org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler";
    private static final String EXPRESSION_HANDLER_ID = "_webExpressionHandler";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Class[] voters;
        BeanDefinitionBuilder fidsBuilder;
        ConfigUtils.registerProviderManagerIfNecessary(parserContext);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        UrlMatcher matcher = HttpSecurityBeanDefinitionParser.createUrlMatcher(element);
        Object source = parserContext.extractSource((Object)element);
        boolean convertPathsToLowerCase = matcher instanceof AntUrlPathMatcher && matcher.requiresLowerCaseUrl();
        List interceptUrlElts = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-url");
        LinkedHashMap filterChainMap = new LinkedHashMap();
        LinkedHashMap channelRequestMap = new LinkedHashMap();
        this.registerFilterChainProxy(parserContext, filterChainMap, matcher, source);
        this.parseInterceptUrlsForChannelSecurityAndFilterChain(interceptUrlElts, filterChainMap, channelRequestMap, convertPathsToLowerCase, parserContext);
        boolean allowSessionCreation = this.registerSecurityContextPersistenceFilter(element, parserContext);
        this.registerServletApiFilter(element, parserContext);
        BeanDefinition portMapper = new PortMappingsBeanDefinitionParser().parse(DomUtils.getChildElementByTagName((Element)element, (String)"port-mappings"), parserContext);
        registry.registerBeanDefinition("_portMapper", portMapper);
        this.registerExceptionTranslationFilter(element, parserContext, allowSessionCreation);
        if (channelRequestMap.size() > 0) {
            this.registerChannelProcessingBeans(parserContext, matcher, channelRequestMap);
        }
        boolean useExpressions = DEF_SERVLET_API_PROVISION.equals(element.getAttribute(ATT_USE_EXPRESSIONS));
        LinkedHashMap<RequestKey, List<ConfigAttribute>> requestToAttributesMap = HttpSecurityBeanDefinitionParser.parseInterceptUrlsForFilterInvocationRequestMap(interceptUrlElts, convertPathsToLowerCase, useExpressions, parserContext);
        if (useExpressions) {
            String expressionHandlerRef;
            Element expressionHandlerElt = DomUtils.getChildElementByTagName((Element)element, (String)"expression-handler");
            String string = expressionHandlerRef = expressionHandlerElt == null ? null : expressionHandlerElt.getAttribute("ref");
            if (StringUtils.hasText((String)expressionHandlerRef)) {
                logger.info((Object)("Using bean '" + expressionHandlerRef + "' as web SecurityExpressionHandler implementation"));
            } else {
                parserContext.getRegistry().registerBeanDefinition(EXPRESSION_HANDLER_ID, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition((String)EXPRESSION_HANDLER_CLASS).getBeanDefinition());
                expressionHandlerRef = EXPRESSION_HANDLER_ID;
            }
            fidsBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)EXPRESSION_FIMDS_CLASS);
            fidsBuilder.addConstructorArgValue((Object)matcher);
            fidsBuilder.addConstructorArgValue(requestToAttributesMap);
            fidsBuilder.addConstructorArgReference(expressionHandlerRef);
            voters = new Class[]{WebExpressionVoter.class};
        } else {
            fidsBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultFilterInvocationSecurityMetadataSource.class);
            fidsBuilder.addConstructorArgValue((Object)matcher);
            fidsBuilder.addConstructorArgValue(requestToAttributesMap);
            voters = new Class[]{RoleVoter.class, AuthenticatedVoter.class};
        }
        fidsBuilder.addPropertyValue("stripQueryStringFromUrls", (Object)(matcher instanceof AntUrlPathMatcher));
        String accessManagerId = element.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText((String)accessManagerId)) {
            parserContext.getRegistry().registerBeanDefinition("_webAccessManager", ConfigUtils.createAccessManagerBean(voters));
            accessManagerId = "_webAccessManager";
        }
        this.registerFilterSecurityInterceptor(element, parserContext, accessManagerId, (BeanDefinition)fidsBuilder.getBeanDefinition());
        boolean sessionControlEnabled = this.registerConcurrentSessionControlBeansIfRequired(element, parserContext);
        this.registerSessionFixationProtectionFilter(parserContext, element.getAttribute(ATT_SESSION_FIXATION_PROTECTION), sessionControlEnabled);
        boolean autoConfig = DEF_SERVLET_API_PROVISION.equals(element.getAttribute(ATT_AUTO_CONFIG));
        Element anonymousElt = DomUtils.getChildElementByTagName((Element)element, (String)"anonymous");
        if (anonymousElt == null || !"false".equals(anonymousElt.getAttribute("enabled"))) {
            new AnonymousBeanDefinitionParser().parse(anonymousElt, parserContext);
        }
        this.parseRememberMeAndLogout(element, autoConfig, parserContext);
        this.parseBasicFormLoginAndOpenID(element, parserContext, autoConfig, allowSessionCreation);
        Element x509Elt = DomUtils.getChildElementByTagName((Element)element, (String)"x509");
        if (x509Elt != null) {
            new X509BeanDefinitionParser().parse(x509Elt, parserContext);
        }
        RootBeanDefinition postProcessor = new RootBeanDefinition(EntryPointInjectionBeanPostProcessor.class);
        postProcessor.setRole(2);
        registry.registerBeanDefinition("_entryPointInjectionBeanPostProcessor", (BeanDefinition)postProcessor);
        RootBeanDefinition postProcessor2 = new RootBeanDefinition(UserDetailsServiceInjectionBeanPostProcessor.class);
        postProcessor2.setRole(2);
        registry.registerBeanDefinition("_userServiceInjectionPostProcessor", (BeanDefinition)postProcessor2);
        return null;
    }

    private void parseRememberMeAndLogout(Element elt, boolean autoConfig, ParserContext pc) {
        Element logoutElt;
        Element rememberMeElt = DomUtils.getChildElementByTagName((Element)elt, (String)"remember-me");
        String rememberMeServices = null;
        if (rememberMeElt != null) {
            RememberMeBeanDefinitionParser rmbdp = new RememberMeBeanDefinitionParser();
            rmbdp.parse(rememberMeElt, pc);
            rememberMeServices = rmbdp.getServicesName();
            RootBeanDefinition rememberMeInjectionPostProcessor = new RootBeanDefinition(RememberMeServicesInjectionBeanPostProcessor.class);
            rememberMeInjectionPostProcessor.setRole(2);
            pc.getRegistry().registerBeanDefinition("_rememberMeServicesInjectionBeanPostProcessor", (BeanDefinition)rememberMeInjectionPostProcessor);
        }
        if ((logoutElt = DomUtils.getChildElementByTagName((Element)elt, (String)"logout")) != null || autoConfig) {
            new LogoutBeanDefinitionParser(rememberMeServices).parse(logoutElt, pc);
        }
    }

    private void registerFilterChainProxy(ParserContext pc, Map filterChainMap, UrlMatcher matcher, Object source) {
        if (pc.getRegistry().containsBeanDefinition("_filterChainProxy")) {
            pc.getReaderContext().error("Duplicate <http> element detected", source);
        }
        RootBeanDefinition filterChainProxy = new RootBeanDefinition(FilterChainProxy.class);
        filterChainProxy.setSource(source);
        filterChainProxy.getPropertyValues().addPropertyValue("matcher", (Object)matcher);
        filterChainProxy.getPropertyValues().addPropertyValue("stripQueryStringFromUrls", (Object)(matcher instanceof AntUrlPathMatcher));
        filterChainProxy.getPropertyValues().addPropertyValue("filterChainMap", (Object)filterChainMap);
        pc.getRegistry().registerBeanDefinition("_filterChainProxy", (BeanDefinition)filterChainProxy);
        pc.getRegistry().registerAlias("_filterChainProxy", "springSecurityFilterChain");
    }

    private boolean registerSecurityContextPersistenceFilter(Element element, ParserContext pc) {
        BeanDefinitionBuilder scpf = BeanDefinitionBuilder.rootBeanDefinition(SecurityContextPersistenceFilter.class);
        boolean sessionCreationAllowed = true;
        String repoRef = element.getAttribute(ATT_SECURITY_CONTEXT_REPOSITORY);
        String createSession = element.getAttribute(ATT_CREATE_SESSION);
        String disableUrlRewriting = element.getAttribute(ATT_DISABLE_URL_REWRITING);
        if (StringUtils.hasText((String)repoRef)) {
            scpf.addPropertyReference("securityContextRepository", repoRef);
            if (OPT_CREATE_SESSION_ALWAYS.equals(createSession)) {
                scpf.addPropertyValue("forceEagerSessionCreation", (Object)Boolean.TRUE);
            } else if (StringUtils.hasText((String)createSession)) {
                pc.getReaderContext().error("If using security-context-repository-ref, the only value you can set for 'create-session' is 'always'. Other session creation logic should be handled by the SecurityContextRepository", (Object)element);
            }
        } else {
            BeanDefinitionBuilder contextRepo = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionSecurityContextRepository.class);
            if (OPT_CREATE_SESSION_ALWAYS.equals(createSession)) {
                contextRepo.addPropertyValue("allowSessionCreation", (Object)Boolean.TRUE);
                scpf.addPropertyValue("forceEagerSessionCreation", (Object)Boolean.TRUE);
            } else if (OPT_CREATE_SESSION_NEVER.equals(createSession)) {
                contextRepo.addPropertyValue("allowSessionCreation", (Object)Boolean.FALSE);
                scpf.addPropertyValue("forceEagerSessionCreation", (Object)Boolean.FALSE);
                sessionCreationAllowed = false;
            } else {
                createSession = DEF_CREATE_SESSION_IF_REQUIRED;
                contextRepo.addPropertyValue("allowSessionCreation", (Object)Boolean.TRUE);
                scpf.addPropertyValue("forceEagerSessionCreation", (Object)Boolean.FALSE);
            }
            if (DEF_SERVLET_API_PROVISION.equals(disableUrlRewriting)) {
                contextRepo.addPropertyValue("disableUrlRewriting", (Object)Boolean.TRUE);
            }
            scpf.addPropertyValue("securityContextRepository", (Object)contextRepo.getBeanDefinition());
        }
        pc.getRegistry().registerBeanDefinition("_securityContextPersistenceFilter", (BeanDefinition)scpf.getBeanDefinition());
        ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_securityContextPersistenceFilter"));
        return sessionCreationAllowed;
    }

    private void registerServletApiFilter(Element element, ParserContext pc) {
        String provideServletApi = element.getAttribute(ATT_SERVLET_API_PROVISION);
        if (!StringUtils.hasText((String)provideServletApi)) {
            provideServletApi = DEF_SERVLET_API_PROVISION;
        }
        if (DEF_SERVLET_API_PROVISION.equals(provideServletApi)) {
            pc.getRegistry().registerBeanDefinition("_securityContextHolderAwareRequestFilter", (BeanDefinition)new RootBeanDefinition(SecurityContextHolderAwareRequestFilter.class));
            ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_securityContextHolderAwareRequestFilter"));
        }
    }

    private boolean registerConcurrentSessionControlBeansIfRequired(Element element, ParserContext parserContext) {
        Element sessionControlElt = DomUtils.getChildElementByTagName((Element)element, (String)"concurrent-session-control");
        if (sessionControlElt == null) {
            return false;
        }
        new ConcurrentSessionsBeanDefinitionParser().parse(sessionControlElt, parserContext);
        logger.info((Object)"Concurrent session filter in use, setting 'forceEagerSessionCreation' to true");
        BeanDefinition sessionIntegrationFilter = parserContext.getRegistry().getBeanDefinition("_securityContextPersistenceFilter");
        sessionIntegrationFilter.getPropertyValues().addPropertyValue("forceEagerSessionCreation", (Object)Boolean.TRUE);
        return true;
    }

    private void registerExceptionTranslationFilter(Element element, ParserContext pc, boolean allowSessionCreation) {
        BeanDefinitionBuilder exceptionTranslationFilterBuilder = BeanDefinitionBuilder.rootBeanDefinition(ExceptionTranslationFilter.class);
        exceptionTranslationFilterBuilder.addPropertyValue("createSessionAllowed", (Object)allowSessionCreation);
        exceptionTranslationFilterBuilder.addPropertyValue("accessDeniedHandler", (Object)this.createAccessDeniedHandler(element, pc));
        pc.getRegistry().registerBeanDefinition("_exceptionTranslationFilter", (BeanDefinition)exceptionTranslationFilterBuilder.getBeanDefinition());
        ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_exceptionTranslationFilter"));
    }

    private BeanMetadataElement createAccessDeniedHandler(Element element, ParserContext pc) {
        String accessDeniedPage = element.getAttribute(ATT_ACCESS_DENIED_PAGE);
        ConfigUtils.validateHttpRedirect(accessDeniedPage, pc, pc.extractSource((Object)element));
        Element accessDeniedElt = DomUtils.getChildElementByTagName((Element)element, (String)"access-denied-handler");
        BeanDefinitionBuilder accessDeniedHandler = BeanDefinitionBuilder.rootBeanDefinition(AccessDeniedHandlerImpl.class);
        if (StringUtils.hasText((String)accessDeniedPage)) {
            if (accessDeniedElt != null) {
                pc.getReaderContext().error("The attribute access-denied-page cannot be used with <access-denied-handler>", pc.extractSource((Object)accessDeniedElt));
            }
            accessDeniedHandler.addPropertyValue("errorPage", (Object)accessDeniedPage);
        }
        if (accessDeniedElt != null) {
            String errorPage = accessDeniedElt.getAttribute(ATT_ACCESS_DENIED_ERROR_PAGE);
            String ref = accessDeniedElt.getAttribute("ref");
            if (StringUtils.hasText((String)errorPage)) {
                if (StringUtils.hasText((String)ref)) {
                    pc.getReaderContext().error("The attribute error-page cannot be used together with the 'ref' attribute within <access-denied-handler>", pc.extractSource((Object)accessDeniedElt));
                }
                accessDeniedHandler.addPropertyValue("errorPage", (Object)errorPage);
            } else if (StringUtils.hasText((String)ref)) {
                return new RuntimeBeanReference(ref);
            }
        }
        return accessDeniedHandler.getBeanDefinition();
    }

    private void registerFilterSecurityInterceptor(Element element, ParserContext pc, String accessManagerId, BeanDefinition fids) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(FilterSecurityInterceptor.class);
        builder.addPropertyReference("accessDecisionManager", accessManagerId);
        builder.addPropertyReference("authenticationManager", "_authenticationManager");
        if ("false".equals(element.getAttribute(ATT_ONCE_PER_REQUEST))) {
            builder.addPropertyValue("observeOncePerRequest", (Object)Boolean.FALSE);
        }
        builder.addPropertyValue("securityMetadataSource", (Object)fids);
        pc.getRegistry().registerBeanDefinition("_filterSecurityInterceptor", (BeanDefinition)builder.getBeanDefinition());
        ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_filterSecurityInterceptor"));
    }

    private void registerChannelProcessingBeans(ParserContext pc, UrlMatcher matcher, LinkedHashMap channelRequestMap) {
        RootBeanDefinition channelFilter = new RootBeanDefinition(ChannelProcessingFilter.class);
        channelFilter.getPropertyValues().addPropertyValue("channelDecisionManager", (Object)new RuntimeBeanReference("_channelDecisionManager"));
        DefaultFilterInvocationSecurityMetadataSource channelFilterInvDefSource = new DefaultFilterInvocationSecurityMetadataSource(matcher, channelRequestMap);
        channelFilterInvDefSource.setStripQueryStringFromUrls(matcher instanceof AntUrlPathMatcher);
        channelFilter.getPropertyValues().addPropertyValue("filterInvocationSecurityMetadataSource", (Object)channelFilterInvDefSource);
        RootBeanDefinition channelDecisionManager = new RootBeanDefinition(ChannelDecisionManagerImpl.class);
        ManagedList channelProcessors = new ManagedList(3);
        RootBeanDefinition secureChannelProcessor = new RootBeanDefinition(SecureChannelProcessor.class);
        RootBeanDefinition retryWithHttp = new RootBeanDefinition(RetryWithHttpEntryPoint.class);
        RootBeanDefinition retryWithHttps = new RootBeanDefinition(RetryWithHttpsEntryPoint.class);
        RuntimeBeanReference portMapper = new RuntimeBeanReference("_portMapper");
        retryWithHttp.getPropertyValues().addPropertyValue("portMapper", (Object)portMapper);
        retryWithHttps.getPropertyValues().addPropertyValue("portMapper", (Object)portMapper);
        secureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", (Object)retryWithHttps);
        RootBeanDefinition inSecureChannelProcessor = new RootBeanDefinition(InsecureChannelProcessor.class);
        inSecureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", (Object)retryWithHttp);
        channelProcessors.add((Object)secureChannelProcessor);
        channelProcessors.add((Object)inSecureChannelProcessor);
        channelDecisionManager.getPropertyValues().addPropertyValue("channelProcessors", (Object)channelProcessors);
        pc.getRegistry().registerBeanDefinition("_channelProcessingFilter", (BeanDefinition)channelFilter);
        ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_channelProcessingFilter"));
        pc.getRegistry().registerBeanDefinition("_channelDecisionManager", (BeanDefinition)channelDecisionManager);
    }

    private void registerSessionFixationProtectionFilter(ParserContext pc, String sessionFixationAttribute, boolean sessionControlEnabled) {
        if (!StringUtils.hasText((String)sessionFixationAttribute)) {
            sessionFixationAttribute = OPT_SESSION_FIXATION_MIGRATE_SESSION;
        }
        if (!sessionFixationAttribute.equals("none")) {
            BeanDefinitionBuilder sessionFixationFilter = BeanDefinitionBuilder.rootBeanDefinition(SessionFixationProtectionFilter.class);
            sessionFixationFilter.addPropertyValue("migrateSessionAttributes", (Object)sessionFixationAttribute.equals(OPT_SESSION_FIXATION_MIGRATE_SESSION));
            if (sessionControlEnabled) {
                sessionFixationFilter.addPropertyReference("sessionRegistry", "_sessionRegistry");
            }
            pc.getRegistry().registerBeanDefinition("_sessionFixationProtectionFilter", (BeanDefinition)sessionFixationFilter.getBeanDefinition());
            ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_sessionFixationProtectionFilter"));
        }
    }

    private void parseBasicFormLoginAndOpenID(Element element, ParserContext pc, boolean autoConfig, boolean allowSessionCreation) {
        String customEntryPoint;
        Element openIDLoginElt;
        Element formLoginElt;
        Element basicAuthElt;
        RootBeanDefinition formLoginFilter = null;
        RootBeanDefinition formLoginEntryPoint = null;
        String formLoginPage = null;
        RootBeanDefinition openIDFilter = null;
        RootBeanDefinition openIDEntryPoint = null;
        String openIDLoginPage = null;
        String realm = element.getAttribute(ATT_REALM);
        if (!StringUtils.hasText((String)realm)) {
            realm = DEF_REALM;
        }
        if ((basicAuthElt = DomUtils.getChildElementByTagName((Element)element, (String)"http-basic")) != null || autoConfig) {
            new BasicAuthenticationBeanDefinitionParser(realm).parse(basicAuthElt, pc);
        }
        if ((formLoginElt = DomUtils.getChildElementByTagName((Element)element, (String)"form-login")) != null || autoConfig) {
            FormLoginBeanDefinitionParser parser = new FormLoginBeanDefinitionParser("/j_spring_security_check", AUTHENTICATION_PROCESSING_FILTER_CLASS);
            parser.parse(formLoginElt, pc);
            formLoginFilter = parser.getFilterBean();
            formLoginEntryPoint = parser.getEntryPointBean();
            formLoginPage = parser.getLoginPage();
        }
        if ((openIDLoginElt = DomUtils.getChildElementByTagName((Element)element, (String)"openid-login")) != null) {
            FormLoginBeanDefinitionParser parser = new FormLoginBeanDefinitionParser("/j_spring_openid_security_check", OPEN_ID_AUTHENTICATION_PROCESSING_FILTER_CLASS);
            parser.parse(openIDLoginElt, pc);
            openIDFilter = parser.getFilterBean();
            openIDEntryPoint = parser.getEntryPointBean();
            openIDLoginPage = parser.getLoginPage();
            BeanDefinitionBuilder openIDProviderBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)OPEN_ID_AUTHENTICATION_PROVIDER_CLASS);
            String userService = openIDLoginElt.getAttribute(ATT_USER_SERVICE_REF);
            if (StringUtils.hasText((String)userService)) {
                openIDProviderBuilder.addPropertyReference("userDetailsService", userService);
            }
            AbstractBeanDefinition openIDProvider = openIDProviderBuilder.getBeanDefinition();
            pc.getRegistry().registerBeanDefinition("_openIDAuthenticationProvider", (BeanDefinition)openIDProvider);
            ConfigUtils.addAuthenticationProvider(pc, "_openIDAuthenticationProvider");
        }
        boolean needLoginPage = false;
        if (formLoginFilter != null) {
            needLoginPage = true;
            formLoginFilter.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)new Boolean(allowSessionCreation));
            pc.getRegistry().registerBeanDefinition("_formLoginFilter", (BeanDefinition)formLoginFilter);
            ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_formLoginFilter"));
            pc.getRegistry().registerBeanDefinition("_formLoginEntryPoint", (BeanDefinition)formLoginEntryPoint);
        }
        if (openIDFilter != null) {
            needLoginPage = true;
            openIDFilter.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)new Boolean(allowSessionCreation));
            pc.getRegistry().registerBeanDefinition("_openIDFilter", (BeanDefinition)openIDFilter);
            ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_openIDFilter"));
            pc.getRegistry().registerBeanDefinition("_openIDFilterEntryPoint", (BeanDefinition)openIDEntryPoint);
        }
        if (needLoginPage && formLoginPage == null && openIDLoginPage == null) {
            logger.info((Object)"No login page configured. The default internal one will be used. Use the 'login-page' attribute to set the URL of the login page.");
            BeanDefinitionBuilder loginPageFilter = BeanDefinitionBuilder.rootBeanDefinition(DefaultLoginPageGeneratingFilter.class);
            if (formLoginFilter != null) {
                loginPageFilter.addConstructorArgValue((Object)new RuntimeBeanReference("_formLoginFilter"));
            }
            if (openIDFilter != null) {
                loginPageFilter.addConstructorArgValue((Object)new RuntimeBeanReference("_openIDFilter"));
            }
            pc.getRegistry().registerBeanDefinition("_defaultLoginPageFilter", (BeanDefinition)loginPageFilter.getBeanDefinition());
            ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_defaultLoginPageFilter"));
        }
        if (StringUtils.hasText((String)(customEntryPoint = element.getAttribute(ATT_ENTRY_POINT_REF)))) {
            pc.getRegistry().registerAlias(customEntryPoint, "_mainEntryPoint");
            return;
        }
        if (basicAuthElt != null && formLoginElt == null && openIDLoginElt == null) {
            pc.getRegistry().registerAlias("_basicAuthenticationEntryPoint", "_mainEntryPoint");
            return;
        }
        if (formLoginFilter != null && openIDLoginPage == null) {
            pc.getRegistry().registerAlias("_formLoginEntryPoint", "_mainEntryPoint");
            return;
        }
        if (openIDFilter != null && formLoginFilter == null) {
            pc.getRegistry().registerAlias("_openIDFilterEntryPoint", "_mainEntryPoint");
            return;
        }
        if (DomUtils.getChildElementByTagName((Element)element, (String)"x509") != null) {
            pc.getRegistry().registerAlias("_preAuthenticatedProcessingFilterEntryPoint", "_mainEntryPoint");
            return;
        }
        pc.getReaderContext().error("No AuthenticationEntryPoint could be established. Please make sure you have a login mechanism configured through the namespace (such as form-login) or specify a custom AuthenticationEntryPoint with the custom-entry-point-ref attribute ", pc.extractSource((Object)element));
    }

    static UrlMatcher createUrlMatcher(Element element) {
        String lowercaseComparisons;
        String patternType = element.getAttribute(ATT_PATH_TYPE);
        if (!StringUtils.hasText((String)patternType)) {
            patternType = DEF_PATH_TYPE_ANT;
        }
        boolean useRegex = patternType.equals(OPT_PATH_TYPE_REGEX);
        AntUrlPathMatcher matcher = new AntUrlPathMatcher();
        if (useRegex) {
            matcher = new RegexUrlPathMatcher();
        }
        if (!StringUtils.hasText((String)(lowercaseComparisons = element.getAttribute(ATT_LOWERCASE_COMPARISONS)))) {
            lowercaseComparisons = null;
        }
        if (DEF_SERVLET_API_PROVISION.equals(lowercaseComparisons)) {
            if (useRegex) {
                ((RegexUrlPathMatcher)matcher).setRequiresLowerCaseUrl(true);
            }
        } else if ("false".equals(lowercaseComparisons) && !useRegex) {
            matcher.setRequiresLowerCaseUrl(false);
        }
        return matcher;
    }

    void parseInterceptUrlsForChannelSecurityAndFilterChain(List<Element> urlElts, Map filterChainMap, Map channelRequestMap, boolean useLowerCasePaths, ParserContext parserContext) {
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        for (Element urlElt : urlElts) {
            String filters;
            String requiredChannel;
            String path = urlElt.getAttribute(ATT_PATH_PATTERN);
            if (!StringUtils.hasText((String)path)) {
                parserContext.getReaderContext().error("path attribute cannot be empty or null", (Object)urlElt);
            }
            if (useLowerCasePaths) {
                path = path.toLowerCase();
            }
            if (StringUtils.hasText((String)(requiredChannel = urlElt.getAttribute(ATT_REQUIRES_CHANNEL)))) {
                String channelConfigAttribute = null;
                if (requiredChannel.equals(OPT_REQUIRES_HTTPS)) {
                    channelConfigAttribute = "REQUIRES_SECURE_CHANNEL";
                } else if (requiredChannel.equals(OPT_REQUIRES_HTTP)) {
                    channelConfigAttribute = "REQUIRES_INSECURE_CHANNEL";
                } else if (requiredChannel.equals(OPT_ANY_CHANNEL)) {
                    channelConfigAttribute = "ANY_CHANNEL";
                } else {
                    parserContext.getReaderContext().error("Unsupported channel " + requiredChannel, (Object)urlElt);
                }
                editor.setAsText(channelConfigAttribute);
                channelRequestMap.put(new RequestKey(path), editor.getValue());
            }
            if (!StringUtils.hasText((String)(filters = urlElt.getAttribute(ATT_FILTERS)))) continue;
            if (!filters.equals("none")) {
                parserContext.getReaderContext().error("Currently only 'none' is supported as the custom filters attribute", (Object)urlElt);
            }
            filterChainMap.put(path, Collections.EMPTY_LIST);
        }
    }

    static LinkedHashMap<RequestKey, List<ConfigAttribute>> parseInterceptUrlsForFilterInvocationRequestMap(List<Element> urlElts, boolean useLowerCasePaths, boolean useExpressions, ParserContext parserContext) {
        LinkedHashMap<RequestKey, List<ConfigAttribute>> filterInvocationDefinitionMap = new LinkedHashMap<RequestKey, List<ConfigAttribute>>();
        for (Element urlElt : urlElts) {
            String method;
            String access = urlElt.getAttribute(ATT_ACCESS_CONFIG);
            if (!StringUtils.hasText((String)access)) continue;
            String path = urlElt.getAttribute(ATT_PATH_PATTERN);
            if (!StringUtils.hasText((String)path)) {
                parserContext.getReaderContext().error("path attribute cannot be empty or null", (Object)urlElt);
            }
            if (useLowerCasePaths) {
                path = path.toLowerCase();
            }
            if (!StringUtils.hasText((String)(method = urlElt.getAttribute(ATT_HTTP_METHOD)))) {
                method = null;
            }
            RequestKey key = new RequestKey(path, method);
            ArrayList<SecurityConfig> attributes = null;
            if (useExpressions) {
                logger.info((Object)("Creating access control expression attribute '" + access + "' for " + key));
                attributes = new ArrayList<SecurityConfig>(1);
                attributes.add(new SecurityConfig(access));
            } else {
                attributes = SecurityConfig.createList((String[])StringUtils.commaDelimitedListToStringArray((String)access));
            }
            if (filterInvocationDefinitionMap.containsKey(key)) {
                logger.warn((Object)("Duplicate URL defined: " + key + ". The original attribute values will be overwritten"));
            }
            filterInvocationDefinitionMap.put(key, (List<ConfigAttribute>)attributes);
        }
        return filterInvocationDefinitionMap;
    }
}

