/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class FormLoginBeanDefinitionParser
implements BeanDefinitionParser {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_LOGIN_URL = "login-processing-url";
    static final String ATT_LOGIN_PAGE = "login-page";
    private static final String DEF_LOGIN_PAGE = "/spring_security_login";
    private static final String ATT_FORM_LOGIN_TARGET_URL = "default-target-url";
    private static final String ATT_ALWAYS_USE_DEFAULT_TARGET_URL = "always-use-default-target";
    private static final String DEF_FORM_LOGIN_TARGET_URL = "/";
    private static final String ATT_FORM_LOGIN_AUTHENTICATION_FAILURE_URL = "authentication-failure-url";
    private static final String DEF_FORM_LOGIN_AUTHENTICATION_FAILURE_URL = "/spring_security_login?login_error";
    private static final String ATT_SUCCESS_HANDLER_REF = "authentication-success-handler-ref";
    private static final String ATT_FAILURE_HANDLER_REF = "authentication-failure-handler-ref";
    private String defaultLoginProcessingUrl;
    private String filterClassName;
    private RootBeanDefinition filterBean;
    private RootBeanDefinition entryPointBean;
    private String loginPage;

    FormLoginBeanDefinitionParser(String defaultLoginProcessingUrl, String filterClassName) {
        this.defaultLoginProcessingUrl = defaultLoginProcessingUrl;
        this.filterClassName = filterClassName;
    }

    public BeanDefinition parse(Element elt, ParserContext pc) {
        String loginUrl = null;
        String defaultTargetUrl = null;
        String authenticationFailureUrl = null;
        String alwaysUseDefault = null;
        String successHandlerRef = null;
        String failureHandlerRef = null;
        Object source = null;
        Boolean sessionFixationProtectionEnabled = new Boolean(pc.getRegistry().containsBeanDefinition("_sessionFixationProtectionFilter"));
        Boolean migrateSessionAttributes = Boolean.FALSE;
        if (sessionFixationProtectionEnabled.booleanValue()) {
            PropertyValue pv = pc.getRegistry().getBeanDefinition("_sessionFixationProtectionFilter").getPropertyValues().getPropertyValue("migrateSessionAttributes");
            migrateSessionAttributes = (Boolean)pv.getValue();
        }
        if (elt != null) {
            source = pc.extractSource((Object)elt);
            loginUrl = elt.getAttribute(ATT_LOGIN_URL);
            ConfigUtils.validateHttpRedirect(loginUrl, pc, source);
            defaultTargetUrl = elt.getAttribute(ATT_FORM_LOGIN_TARGET_URL);
            ConfigUtils.validateHttpRedirect(defaultTargetUrl, pc, source);
            authenticationFailureUrl = elt.getAttribute(ATT_FORM_LOGIN_AUTHENTICATION_FAILURE_URL);
            ConfigUtils.validateHttpRedirect(authenticationFailureUrl, pc, source);
            alwaysUseDefault = elt.getAttribute(ATT_ALWAYS_USE_DEFAULT_TARGET_URL);
            this.loginPage = elt.getAttribute(ATT_LOGIN_PAGE);
            successHandlerRef = elt.getAttribute(ATT_SUCCESS_HANDLER_REF);
            failureHandlerRef = elt.getAttribute(ATT_FAILURE_HANDLER_REF);
            if (!StringUtils.hasText((String)this.loginPage)) {
                this.loginPage = null;
            }
            ConfigUtils.validateHttpRedirect(this.loginPage, pc, source);
        }
        ConfigUtils.registerProviderManagerIfNecessary(pc);
        this.filterBean = this.createFilterBean(loginUrl, defaultTargetUrl, alwaysUseDefault, this.loginPage, authenticationFailureUrl, successHandlerRef, failureHandlerRef);
        this.filterBean.setSource(source);
        this.filterBean.getPropertyValues().addPropertyValue("authenticationManager", (Object)new RuntimeBeanReference("_authenticationManager"));
        this.filterBean.getPropertyValues().addPropertyValue("invalidateSessionOnSuccessfulAuthentication", (Object)sessionFixationProtectionEnabled);
        this.filterBean.getPropertyValues().addPropertyValue("migrateInvalidatedSessionAttributes", (Object)migrateSessionAttributes);
        if (pc.getRegistry().containsBeanDefinition("_rememberMeServices")) {
            this.filterBean.getPropertyValues().addPropertyValue("rememberMeServices", (Object)new RuntimeBeanReference("_rememberMeServices"));
        }
        if (pc.getRegistry().isBeanNameInUse("_sessionRegistry")) {
            this.filterBean.getPropertyValues().addPropertyValue("sessionRegistry", (Object)new RuntimeBeanReference("_sessionRegistry"));
        }
        BeanDefinitionBuilder entryPointBuilder = BeanDefinitionBuilder.rootBeanDefinition(LoginUrlAuthenticationEntryPoint.class);
        entryPointBuilder.getRawBeanDefinition().setSource(source);
        entryPointBuilder.addPropertyValue("loginFormUrl", (Object)(this.loginPage != null ? this.loginPage : DEF_LOGIN_PAGE));
        this.entryPointBean = (RootBeanDefinition)entryPointBuilder.getBeanDefinition();
        return null;
    }

    private RootBeanDefinition createFilterBean(String loginUrl, String defaultTargetUrl, String alwaysUseDefault, String loginPage, String authenticationFailureUrl, String successHandlerRef, String failureHandlerRef) {
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)this.filterClassName);
        if (!StringUtils.hasText((String)loginUrl)) {
            loginUrl = this.defaultLoginProcessingUrl;
        }
        filterBuilder.addPropertyValue("filterProcessesUrl", (Object)loginUrl);
        if (StringUtils.hasText((String)successHandlerRef)) {
            filterBuilder.addPropertyReference("authenticationSuccessHandler", successHandlerRef);
        } else {
            BeanDefinitionBuilder successHandler = BeanDefinitionBuilder.rootBeanDefinition(SavedRequestAwareAuthenticationSuccessHandler.class);
            if ("true".equals(alwaysUseDefault)) {
                successHandler.addPropertyValue("alwaysUseDefaultTargetUrl", (Object)Boolean.TRUE);
            }
            successHandler.addPropertyValue("defaultTargetUrl", (Object)(StringUtils.hasText((String)defaultTargetUrl) ? defaultTargetUrl : DEF_FORM_LOGIN_TARGET_URL));
            filterBuilder.addPropertyValue("authenticationSuccessHandler", (Object)successHandler.getBeanDefinition());
        }
        if (StringUtils.hasText((String)failureHandlerRef)) {
            filterBuilder.addPropertyReference("authenticationFailureHandler", failureHandlerRef);
        } else {
            BeanDefinitionBuilder failureHandler = BeanDefinitionBuilder.rootBeanDefinition(SimpleUrlAuthenticationFailureHandler.class);
            if (!StringUtils.hasText((String)authenticationFailureUrl)) {
                authenticationFailureUrl = StringUtils.hasText((String)loginPage) ? loginPage : DEF_FORM_LOGIN_AUTHENTICATION_FAILURE_URL;
            }
            failureHandler.addPropertyValue("defaultFailureUrl", (Object)authenticationFailureUrl);
            filterBuilder.addPropertyValue("authenticationFailureHandler", (Object)failureHandler.getBeanDefinition());
        }
        return (RootBeanDefinition)filterBuilder.getBeanDefinition();
    }

    RootBeanDefinition getFilterBean() {
        return this.filterBean;
    }

    RootBeanDefinition getEntryPointBean() {
        return this.entryPointBean;
    }

    String getLoginPage() {
        return this.loginPage;
    }
}

