/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.config.HttpSecurityBeanDefinitionParser;
import org.springframework.security.web.access.intercept.RequestKey;
import org.springframework.security.web.util.AntUrlPathMatcher;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FilterInvocationSecurityMetadataSourceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected String getBeanClassName(Element element) {
        return "org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List interceptUrls = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-url");
        for (Element elt : interceptUrls) {
            if (StringUtils.hasLength((String)elt.getAttribute("requires-channel"))) {
                parserContext.getReaderContext().error("The attribute 'requires-channel' isn't allowed here.", (Object)elt);
            }
            if (!StringUtils.hasLength((String)elt.getAttribute("filters"))) continue;
            parserContext.getReaderContext().error("The attribute 'filters' isn't allowed here.", (Object)elt);
        }
        UrlMatcher matcher = HttpSecurityBeanDefinitionParser.createUrlMatcher(element);
        boolean convertPathsToLowerCase = matcher instanceof AntUrlPathMatcher && matcher.requiresLowerCaseUrl();
        LinkedHashMap<RequestKey, List<ConfigAttribute>> requestMap = HttpSecurityBeanDefinitionParser.parseInterceptUrlsForFilterInvocationRequestMap(interceptUrls, convertPathsToLowerCase, false, parserContext);
        builder.addConstructorArgValue((Object)matcher);
        builder.addConstructorArgValue(requestMap);
    }
}

