/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.web.authentication.www.BasicProcessingFilter;
import org.springframework.security.web.authentication.www.BasicProcessingFilterEntryPoint;
import org.w3c.dom.Element;

public class BasicAuthenticationBeanDefinitionParser
implements BeanDefinitionParser {
    private String realmName;

    public BasicAuthenticationBeanDefinitionParser(String realmName) {
        this.realmName = realmName;
    }

    public BeanDefinition parse(Element elt, ParserContext parserContext) {
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(BasicProcessingFilter.class);
        RootBeanDefinition entryPoint = new RootBeanDefinition(BasicProcessingFilterEntryPoint.class);
        entryPoint.setSource(parserContext.extractSource((Object)elt));
        entryPoint.setRole(2);
        entryPoint.getPropertyValues().addPropertyValue("realmName", (Object)this.realmName);
        parserContext.getRegistry().registerBeanDefinition("_basicAuthenticationEntryPoint", (BeanDefinition)entryPoint);
        filterBuilder.addPropertyValue("authenticationManager", (Object)new RuntimeBeanReference("_authenticationManager"));
        filterBuilder.addPropertyValue("authenticationEntryPoint", (Object)new RuntimeBeanReference("_basicAuthenticationEntryPoint"));
        parserContext.getRegistry().registerBeanDefinition("_basicAuthenticationFilter", (BeanDefinition)filterBuilder.getBeanDefinition());
        ConfigUtils.addHttpFilter(parserContext, (BeanMetadataElement)new RuntimeBeanReference("_basicAuthenticationFilter"));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)filterBuilder.getBeanDefinition(), "_basicAuthenticationFilter"));
        return null;
    }
}

