/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.cas.authentication;

import java.io.Serializable;
import java.util.Collection;
import org.apereo.cas.client.validation.Assertion;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class CasAuthenticationToken
extends AbstractAuthenticationToken
implements Serializable {
    private static final long serialVersionUID = 620L;
    private final Object credentials;
    private final Object principal;
    private final UserDetails userDetails;
    private final int keyHash;
    private final Assertion assertion;

    public CasAuthenticationToken(String key, Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities, UserDetails userDetails, Assertion assertion) {
        this(CasAuthenticationToken.extractKeyHash(key), principal, credentials, authorities, userDetails, assertion);
    }

    private CasAuthenticationToken(Integer keyHash, Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities, UserDetails userDetails, Assertion assertion) {
        super(authorities);
        if (principal == null || "".equals(principal) || credentials == null || "".equals(credentials) || authorities == null || userDetails == null || assertion == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.keyHash = keyHash;
        this.principal = principal;
        this.credentials = credentials;
        this.userDetails = userDetails;
        this.assertion = assertion;
        this.setAuthenticated(true);
    }

    protected CasAuthenticationToken(Builder<?> builder) {
        super(builder);
        Assert.isTrue((!"".equals(builder.principal) ? 1 : 0) != 0, (String)"principal cannot be null or empty");
        Assert.notNull((Object)(!"".equals(builder.credentials) ? 1 : 0), (String)"credentials cannot be null or empty");
        Assert.notNull((Object)builder.userDetails, (String)"userDetails cannot be null");
        Assert.notNull((Object)builder.assertion, (String)"assertion cannot be null");
        this.keyHash = builder.keyHash;
        this.principal = builder.principal;
        this.credentials = builder.credentials;
        this.userDetails = builder.userDetails;
        this.assertion = builder.assertion;
    }

    private static Integer extractKeyHash(String key) {
        Assert.hasLength((String)key, (String)"key cannot be null or empty");
        return key.hashCode();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof CasAuthenticationToken) {
            CasAuthenticationToken test = (CasAuthenticationToken)obj;
            return this.assertion.equals(test.getAssertion()) && this.getKeyHash() == test.getKeyHash();
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.credentials.hashCode();
        result = 31 * result + this.principal.hashCode();
        result = 31 * result + this.userDetails.hashCode();
        result = 31 * result + this.keyHash;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.assertion);
        return result;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" Assertion: ").append(this.assertion);
        sb.append(" Credentials (Service/Proxy Ticket): ").append(this.credentials);
        return sb.toString();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAuthenticationToken.AbstractAuthenticationBuilder<B> {
        private Integer keyHash;
        private Object principal;
        private Object credentials;
        private UserDetails userDetails;
        private Assertion assertion;

        protected Builder(CasAuthenticationToken token) {
            super((AbstractAuthenticationToken)token);
            this.keyHash = token.keyHash;
            this.principal = token.principal;
            this.credentials = token.credentials;
            this.userDetails = token.userDetails;
            this.assertion = token.assertion;
        }

        public B key(String key) {
            this.keyHash = key.hashCode();
            return (B)((Object)this);
        }

        public B principal(@Nullable Object principal) {
            Assert.notNull((Object)principal, (String)"principal cannot be null");
            this.principal = principal;
            return (B)((Object)this);
        }

        public B credentials(@Nullable Object credentials) {
            Assert.notNull((Object)credentials, (String)"credentials cannot be null");
            this.credentials = credentials;
            return (B)((Object)this);
        }

        public B userDetails(UserDetails userDetails) {
            this.userDetails = userDetails;
            return (B)((Object)this);
        }

        public B assertion(Assertion assertion) {
            this.assertion = assertion;
            return (B)((Object)this);
        }

        public CasAuthenticationToken build() {
            return new CasAuthenticationToken(this);
        }
    }
}

