/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.cas.authentication;

import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.cas.authentication.StatelessTicketCache;
import org.springframework.util.Assert;

public class EhCacheBasedTicketCache
implements StatelessTicketCache,
InitializingBean {
    private static final Log logger = LogFactory.getLog(EhCacheBasedTicketCache.class);
    private Ehcache cache;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"cache mandatory");
    }

    public CasAuthenticationToken getByTicketId(String serviceTicket) {
        try {
            Element element = this.cache.get((Serializable)((Object)serviceTicket));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache hit: " + (element != null) + "; service ticket: " + serviceTicket));
            }
            return element == null ? null : (CasAuthenticationToken)element.getValue();
        }
        catch (CacheException cacheException) {
            throw new DataRetrievalFailureException("Cache failure: " + cacheException.getMessage());
        }
    }

    public Ehcache getCache() {
        return this.cache;
    }

    public void putTicketInCache(CasAuthenticationToken token) {
        Element element = new Element((Serializable)((Object)token.getCredentials().toString()), (Serializable)token);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + element.getKey()));
        }
        this.cache.put(element);
    }

    public void removeTicketFromCache(CasAuthenticationToken token) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + token.getCredentials().toString()));
        }
        this.removeTicketFromCache(token.getCredentials().toString());
    }

    public void removeTicketFromCache(String serviceTicket) {
        this.cache.remove((Serializable)((Object)serviceTicket));
    }

    public void setCache(Ehcache cache) {
        this.cache = cache;
    }
}

