/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.jdbc;

import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.springframework.security.acls.MutableAcl;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AclImpl;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.jdbc.AclCache;
import org.springframework.security.acls.objectidentity.ObjectIdentity;
import org.springframework.security.util.FieldUtils;
import org.springframework.util.Assert;

public class EhCacheBasedAclCache
implements AclCache {
    private Ehcache cache;
    private AuditLogger auditLogger;
    private AclAuthorizationStrategy aclAuthorizationStrategy;

    public EhCacheBasedAclCache(Ehcache cache) {
        Assert.notNull((Object)cache, (String)"Cache required");
        this.cache = cache;
    }

    public void evictFromCache(Serializable pk) {
        Assert.notNull((Object)pk, (String)"Primary key (identifier) required");
        MutableAcl acl = this.getFromCache(pk);
        if (acl != null) {
            this.cache.remove(acl.getId());
            this.cache.remove((Serializable)acl.getObjectIdentity());
        }
    }

    public void evictFromCache(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, (String)"ObjectIdentity required");
        MutableAcl acl = this.getFromCache(objectIdentity);
        if (acl != null) {
            this.cache.remove(acl.getId());
            this.cache.remove((Serializable)acl.getObjectIdentity());
        }
    }

    public MutableAcl getFromCache(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, (String)"ObjectIdentity required");
        Element element = null;
        try {
            element = this.cache.get((Serializable)objectIdentity);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        if (element == null) {
            return null;
        }
        return this.initializeTransientFields((MutableAcl)element.getValue());
    }

    public MutableAcl getFromCache(Serializable pk) {
        Assert.notNull((Object)pk, (String)"Primary key (identifier) required");
        Element element = null;
        try {
            element = this.cache.get(pk);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        if (element == null) {
            return null;
        }
        return this.initializeTransientFields((MutableAcl)element.getValue());
    }

    public void putInCache(MutableAcl acl) {
        Assert.notNull((Object)acl, (String)"Acl required");
        Assert.notNull((Object)acl.getObjectIdentity(), (String)"ObjectIdentity required");
        Assert.notNull((Object)acl.getId(), (String)"ID required");
        if (this.aclAuthorizationStrategy == null && acl instanceof AclImpl) {
            this.aclAuthorizationStrategy = (AclAuthorizationStrategy)FieldUtils.getProtectedFieldValue((String)"aclAuthorizationStrategy", (Object)acl);
            this.auditLogger = (AuditLogger)FieldUtils.getProtectedFieldValue((String)"auditLogger", (Object)acl);
        }
        if (acl.getParentAcl() != null && acl.getParentAcl() instanceof MutableAcl) {
            this.putInCache((MutableAcl)acl.getParentAcl());
        }
        this.cache.put(new Element((Serializable)acl.getObjectIdentity(), (Serializable)acl));
        this.cache.put(new Element(acl.getId(), (Serializable)acl));
    }

    private MutableAcl initializeTransientFields(MutableAcl value) {
        if (value instanceof AclImpl) {
            FieldUtils.setProtectedFieldValue((String)"aclAuthorizationStrategy", (Object)value, (Object)this.aclAuthorizationStrategy);
            FieldUtils.setProtectedFieldValue((String)"auditLogger", (Object)value, (Object)this.auditLogger);
        }
        return value;
    }
}

