/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store.redis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.serializer.support.SerializationFailedException;
import org.springframework.security.oauth2.provider.token.store.redis.SaferObjectInputStream;
import org.springframework.security.oauth2.provider.token.store.redis.StandardStringSerializationStrategy;

public class JdkSerializationStrategy
extends StandardStringSerializationStrategy {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private static final List<String> ALLOWED_CLASSES;

    @Override
    protected <T> T deserializeInternal(byte[] bytes, Class<T> clazz) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            SaferObjectInputStream saferObjectInputStream = new SaferObjectInputStream(new ByteArrayInputStream(bytes), ALLOWED_CLASSES);
            return (T)saferObjectInputStream.readObject();
        }
        catch (Exception e) {
            throw new SerializationFailedException("Failed to deserialize payload", (Throwable)e);
        }
    }

    @Override
    protected byte[] serializeInternal(Object object) {
        if (object == null) {
            return EMPTY_ARRAY;
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " requires a Serializable payload but received an object of type [" + object.getClass().getName() + "]");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new SerializationFailedException("Failed to serialize object", (Throwable)e);
        }
    }

    static {
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("java.lang.");
        classes.add("java.util.");
        classes.add("org.springframework.security.");
        ALLOWED_CLASSES = Collections.unmodifiableList(classes);
    }
}

