/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.token.store.JwtClaimsSetVerifier;
import org.springframework.util.Assert;

public class DelegatingJwtClaimsSetVerifier
implements JwtClaimsSetVerifier {
    private final List<JwtClaimsSetVerifier> jwtClaimsSetVerifiers;

    public DelegatingJwtClaimsSetVerifier(List<JwtClaimsSetVerifier> jwtClaimsSetVerifiers) {
        Assert.notEmpty(jwtClaimsSetVerifiers, (String)"jwtClaimsSetVerifiers cannot be empty");
        this.jwtClaimsSetVerifiers = Collections.unmodifiableList(new ArrayList<JwtClaimsSetVerifier>(jwtClaimsSetVerifiers));
    }

    @Override
    public void verify(Map<String, Object> claims) throws InvalidTokenException {
        for (JwtClaimsSetVerifier jwtClaimsSetVerifier : this.jwtClaimsSetVerifiers) {
            jwtClaimsSetVerifier.verify(claims);
        }
    }
}

