/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;

public class OAuth2Authentication
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -4809832298438307309L;
    private final OAuth2Request storedRequest;
    private final Authentication userAuthentication;

    public OAuth2Authentication(OAuth2Request storedRequest, Authentication userAuthentication) {
        super(userAuthentication == null ? storedRequest.getAuthorities() : userAuthentication.getAuthorities());
        this.storedRequest = storedRequest;
        this.userAuthentication = userAuthentication;
    }

    public Object getCredentials() {
        return "";
    }

    public Object getPrincipal() {
        return this.userAuthentication == null ? this.storedRequest.getClientId() : this.userAuthentication.getPrincipal();
    }

    public boolean isClientOnly() {
        return this.userAuthentication == null;
    }

    public OAuth2Request getOAuth2Request() {
        return this.storedRequest;
    }

    public Authentication getUserAuthentication() {
        return this.userAuthentication;
    }

    public boolean isAuthenticated() {
        return this.storedRequest.isApproved() && (this.userAuthentication == null || this.userAuthentication.isAuthenticated());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuth2Authentication)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuth2Authentication that = (OAuth2Authentication)((Object)o);
        if (!this.storedRequest.equals(that.storedRequest)) {
            return false;
        }
        return !(this.userAuthentication != null ? !this.userAuthentication.equals((Object)that.userAuthentication) : that.userAuthentication != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.storedRequest.hashCode();
        result = 31 * result + (this.userAuthentication != null ? this.userAuthentication.hashCode() : 0);
        return result;
    }
}

