/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.token;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.ClientKeyGenerator;
import org.springframework.security.oauth2.client.token.ClientTokenServices;
import org.springframework.security.oauth2.client.token.DefaultClientKeyGenerator;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.util.SerializationUtils;
import org.springframework.util.Assert;

public class JdbcClientTokenServices
implements ClientTokenServices {
    private static final Log LOG = LogFactory.getLog(JdbcClientTokenServices.class);
    private static final String DEFAULT_ACCESS_TOKEN_INSERT_STATEMENT = "insert into oauth_client_token (token_id, token, authentication_id, user_name, client_id) values (?, ?, ?, ?, ?)";
    private static final String DEFAULT_ACCESS_TOKEN_FROM_AUTHENTICATION_SELECT_STATEMENT = "select token_id, token from oauth_client_token where authentication_id = ?";
    private static final String DEFAULT_ACCESS_TOKEN_DELETE_STATEMENT = "delete from oauth_client_token where authentication_id = ?";
    private String insertAccessTokenSql = "insert into oauth_client_token (token_id, token, authentication_id, user_name, client_id) values (?, ?, ?, ?, ?)";
    private String selectAccessTokenSql = "select token_id, token from oauth_client_token where authentication_id = ?";
    private String deleteAccessTokenSql = "delete from oauth_client_token where authentication_id = ?";
    private ClientKeyGenerator keyGenerator = new DefaultClientKeyGenerator();
    private final JdbcTemplate jdbcTemplate;

    public JdbcClientTokenServices(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setClientKeyGenerator(ClientKeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    @Override
    public OAuth2AccessToken getAccessToken(OAuth2ProtectedResourceDetails resource, Authentication authentication) {
        OAuth2AccessToken accessToken;
        block2: {
            accessToken = null;
            try {
                accessToken = (OAuth2AccessToken)this.jdbcTemplate.queryForObject(this.selectAccessTokenSql, (RowMapper)new RowMapper<OAuth2AccessToken>(){

                    public OAuth2AccessToken mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (OAuth2AccessToken)SerializationUtils.deserialize(rs.getBytes(2));
                    }
                }, new Object[]{this.keyGenerator.extractKey(resource, authentication)});
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.debug((Object)("Failed to find access token for authentication " + authentication));
            }
        }
        return accessToken;
    }

    @Override
    public void saveAccessToken(OAuth2ProtectedResourceDetails resource, Authentication authentication, OAuth2AccessToken accessToken) {
        this.removeAccessToken(resource, authentication);
        this.jdbcTemplate.update(this.insertAccessTokenSql, new Object[]{accessToken.getValue(), new SqlLobValue(SerializationUtils.serialize(accessToken)), this.keyGenerator.extractKey(resource, authentication), authentication.getName(), resource.getClientId()}, new int[]{12, 2004, 12, 12, 12});
    }

    @Override
    public void removeAccessToken(OAuth2ProtectedResourceDetails resource, Authentication authentication) {
        this.jdbcTemplate.update(this.deleteAccessTokenSql, new Object[]{this.keyGenerator.extractKey(resource, authentication)});
    }

    public void setInsertAccessTokenSql(String insertAccessTokenSql) {
        this.insertAccessTokenSql = insertAccessTokenSql;
    }

    public void setSelectAccessTokenSql(String selectAccessTokenSql) {
        this.selectAccessTokenSql = selectAccessTokenSql;
    }

    public void setDeleteAccessTokenSql(String deleteAccessTokenSql) {
        this.deleteAccessTokenSql = deleteAccessTokenSql;
    }
}

