/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpoint;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class FrameworkEndpointHandlerMapping
extends RequestMappingHandlerMapping {
    private Map<String, String> mappings = new HashMap<String, String>();
    private String approvalParameter = "user_oauth_approval";

    public void setMappings(Map<String, String> patternMap) {
        this.mappings = patternMap;
    }

    public void setApprovalParameter(String approvalParameter) {
        this.approvalParameter = approvalParameter;
    }

    public FrameworkEndpointHandlerMapping() {
        this.setOrder(0x7FFFFFFE);
    }

    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, FrameworkEndpoint.class) != null;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo defaultMapping = super.getMappingForMethod(method, handlerType);
        if (defaultMapping == null) {
            return null;
        }
        Set defaultPatterns = defaultMapping.getPatternsCondition().getPatterns();
        String[] patterns = new String[defaultPatterns.size()];
        int i = 0;
        Iterator i$ = defaultPatterns.iterator();
        while (i$.hasNext()) {
            String pattern;
            patterns[i] = pattern = (String)i$.next();
            if (this.mappings.containsKey(pattern)) {
                patterns[i] = this.mappings.get(pattern);
            }
            ++i;
        }
        PatternsRequestCondition patternsInfo = new PatternsRequestCondition(patterns);
        ParamsRequestCondition paramsInfo = defaultMapping.getParamsCondition();
        if (!this.approvalParameter.equals("user_oauth_approval") && defaultPatterns.contains("/oauth/authorize")) {
            String[] params = new String[paramsInfo.getExpressions().size()];
            Set expressions = paramsInfo.getExpressions();
            i = 0;
            for (NameValueExpression expression : expressions) {
                String param = expression.toString();
                params[i] = "user_oauth_approval".equals(param) ? this.approvalParameter : param;
                ++i;
            }
            paramsInfo = new ParamsRequestCondition(params);
        }
        RequestMappingInfo mapping = new RequestMappingInfo(patternsInfo, defaultMapping.getMethodsCondition(), paramsInfo, defaultMapping.getHeadersCondition(), defaultMapping.getConsumesCondition(), defaultMapping.getProducesCondition(), defaultMapping.getCustomCondition());
        return mapping;
    }
}

