/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientCredentialsChecker;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTokenGranter
implements TokenGranter {
    private final AuthorizationServerTokenServices tokenServices;
    private final ClientCredentialsChecker clientCredentialsChecker;
    private final String grantType;

    protected AbstractTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, String grantType) {
        this.grantType = grantType;
        this.clientCredentialsChecker = new ClientCredentialsChecker(clientDetailsService);
        this.tokenServices = tokenServices;
    }

    @Override
    public OAuth2AccessToken grant(String grantType, Map<String, String> parameters, String clientId, Set<String> scopes) {
        if (!this.grantType.equals(grantType)) {
            return null;
        }
        AuthorizationRequest clientToken = this.clientCredentialsChecker.validateCredentials(grantType, clientId, scopes);
        return this.tokenServices.createAccessToken(this.getOAuth2Authentication(parameters, clientToken));
    }

    protected abstract OAuth2Authentication getOAuth2Authentication(Map<String, String> var1, AuthorizationRequest var2);
}

