/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class OAuth2ProtectedResourceFilter
extends GenericFilterBean {
    private ResourceServerTokenServices tokenServices;
    private String resourceId;

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.tokenServices, (String)"OAuth 2 token services must be supplied.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String token = this.parseToken(request);
        if (token != null) {
            OAuth2Authentication auth = this.tokenServices.loadAuthentication(token);
            if (auth == null) {
                throw new InvalidTokenException("Invalid token: " + token);
            }
            Set<String> resourceIds = auth.getAuthorizationRequest().getResourceIds();
            if (resourceIds != null && !resourceIds.isEmpty() && !resourceIds.contains(this.resourceId)) {
                throw new InvalidTokenException("Invalid token does not contain resource id (" + this.resourceId + "): " + token);
            }
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Chain processed normally");
        }
    }

    protected String parseToken(HttpServletRequest request) {
        String token = this.parseHeaderToken(request);
        if (token == null) {
            this.logger.debug((Object)"Token not found in headers. Trying request parameters.");
            token = request.getParameter(OAuth2AccessToken.ACCESS_TOKEN);
            if (token == null) {
                this.logger.debug((Object)"Token not found in request parameters.  Not an OAuth2 request.");
            }
        }
        return token;
    }

    protected String parseHeaderToken(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String authHeaderValue;
            String value = (String)headers.nextElement();
            if (!value.toLowerCase().startsWith(OAuth2AccessToken.BEARER_TYPE.toLowerCase()) || (authHeaderValue = value.substring(OAuth2AccessToken.BEARER_TYPE.length()).trim()).contains("oauth_signature_method") || authHeaderValue.contains("oauth_verifier")) continue;
            int commaIndex = authHeaderValue.indexOf(44);
            if (commaIndex > 0) {
                authHeaderValue = authHeaderValue.substring(0, commaIndex);
            }
            return authHeaderValue;
        }
        return null;
    }

    @Autowired
    public void setTokenServices(ResourceServerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }
}

