/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.filter;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.provider.web.DefaultOAuth2ExceptionRenderer;
import org.springframework.security.oauth2.provider.web.OAuth2ExceptionRenderer;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.Assert;
import org.springframework.web.context.request.ServletWebRequest;

public final class OAuth2AuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private OAuth2ExceptionRenderer exceptionRenderer = new DefaultOAuth2ExceptionRenderer();

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        InvalidClientException result = new InvalidClientException(exception.getMessage(), (Throwable)exception);
        HttpStatus status = HttpStatus.valueOf((int)result.getHttpErrorCode());
        ResponseEntity responseEntity = new ResponseEntity((Object)result, status);
        try {
            this.exceptionRenderer.handleHttpEntityResponse((HttpEntity<?>)responseEntity, new ServletWebRequest(request, response));
        }
        catch (Exception e) {
            throw new ServletException("Failed to render " + responseEntity, (Throwable)e);
        }
    }

    public void setExceptionRenderer(OAuth2ExceptionRenderer exceptionRenderer) {
        Assert.notNull((Object)exceptionRenderer, (String)"exceptionRenderer cannot be null");
        this.exceptionRenderer = exceptionRenderer;
    }
}

