/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.error;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeAwareAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private String realmName;
    private String typeName = OAuth2AccessToken.BEARER_TYPE;
    private MediaType defaultMediaType = MediaType.APPLICATION_JSON;
    private Map<MediaType, String> responses = new LinkedHashMap<MediaType, String>();

    public MediaTypeAwareAuthenticationEntryPoint() {
        this.responses.put(MediaType.APPLICATION_JSON, "{\"error\":\"%s\"}");
        this.responses.put(MediaType.APPLICATION_XML, "<error>%s</error>");
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((boolean)StringUtils.hasText((String)this.realmName), (String)"realmName must be specified");
        Assert.state((boolean)this.responses.containsKey(this.defaultMediaType), (String)"defaultMediaType must be one of MediaType.APPLICATION_JSON or MediaType.APPLICATION_XML");
    }

    public void setResponses(Map<MediaType, String> responses) {
        this.responses = new LinkedHashMap<MediaType, String>(responses);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        this.addAuthenticateHeader(response, authException);
        String accept = request.getHeader("Accept");
        MediaType mediaType = this.selectMediaType(accept);
        if (mediaType != null) {
            response.setStatus(401);
            response.setContentType(mediaType.toString());
            String format = this.responses.get(mediaType);
            response.getWriter().append(this.generateResponseBody(format, authException));
        } else {
            response.sendError(401, authException.getMessage());
        }
    }

    protected String generateResponseBody(String format, AuthenticationException authException) {
        return String.format(format, authException.getMessage());
    }

    private MediaType selectMediaType(String accept) {
        if (StringUtils.hasText((String)accept)) {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)accept)) {
                for (MediaType candidate : this.responses.keySet()) {
                    if (!mediaType.includes(candidate)) continue;
                    return candidate;
                }
            }
        }
        return this.defaultMediaType;
    }

    private void addAuthenticateHeader(HttpServletResponse response, AuthenticationException authException) {
        if (response.containsHeader("WWW-Authenticate")) {
            return;
        }
        StringBuilder builder = new StringBuilder(String.format("%s realm=\"%s\"", this.typeName, this.realmName));
        if (authException instanceof OAuth2Exception) {
            OAuth2Exception oauth2Exception = (OAuth2Exception)authException;
            builder.append(", " + oauth2Exception.getSummary());
        }
        response.addHeader("WWW-Authenticate", builder.toString());
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public void setDefaultMediaType(MediaType mediaType) {
        this.defaultMediaType = mediaType;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}

