/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.error;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.MediaType;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeAwareAccessDeniedHandler
implements AccessDeniedHandler {
    private Map<MediaType, String> responses = new LinkedHashMap<MediaType, String>();

    public MediaTypeAwareAccessDeniedHandler() {
        this.responses.put(MediaType.APPLICATION_JSON, "{\"error\":\"%s\"}");
        this.responses.put(MediaType.APPLICATION_XML, "<error>%s</error>");
    }

    public void setResponses(Map<MediaType, String> responses) {
        this.responses = new LinkedHashMap<MediaType, String>(responses);
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException authException) throws IOException, ServletException {
        String accept = request.getHeader("Accept");
        MediaType mediaType = this.selectMediaType(accept);
        if (mediaType != null) {
            response.setStatus(403);
            response.setContentType(mediaType.toString());
            String format = this.responses.get(mediaType);
            response.getWriter().append(this.generateResponseBody(format, authException));
        } else {
            response.sendError(403, authException.getMessage());
        }
    }

    protected String generateResponseBody(String format, AccessDeniedException authException) {
        return String.format(format, authException.getMessage());
    }

    private MediaType selectMediaType(String accept) {
        if (StringUtils.hasText((String)accept)) {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)accept)) {
                for (MediaType candidate : this.responses.keySet()) {
                    if (!mediaType.includes(candidate)) continue;
                    return mediaType;
                }
            }
        }
        return null;
    }
}

