/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.security.Principal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.UnapprovedClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedGrantTypeException;
import org.springframework.security.oauth2.common.exceptions.UserDeniedAuthorizationException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.approval.DefaultUserApprovalHandler;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationRequestHolder;
import org.springframework.security.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.endpoint.AbstractEndpoint;
import org.springframework.security.oauth2.provider.endpoint.DefaultRedirectResolver;
import org.springframework.security.oauth2.provider.endpoint.RedirectResolver;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@SessionAttributes(types={AuthorizationRequest.class})
@RequestMapping(value={"/oauth/authorize"})
public class AuthorizationEndpoint
extends AbstractEndpoint
implements InitializingBean {
    public static final String USER_OAUTH_APPROVAL = "user_oauth_approval";
    private ClientDetailsService clientDetailsService;
    private AuthorizationCodeServices authorizationCodeServices = new InMemoryAuthorizationCodeServices();
    private RedirectResolver redirectResolver = new DefaultRedirectResolver();
    private UserApprovalHandler userApprovalHandler = new DefaultUserApprovalHandler();
    private String userApprovalPage = "forward:/oauth/confirm_access";

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state((this.clientDetailsService != null ? 1 : 0) != 0, (String)"ClientDetailsService must be provided");
    }

    @RequestMapping(params={"response_type"})
    public ModelAndView authorize(Map<String, Object> model, @RequestParam(value="response_type") String responseType, @RequestParam Map<String, String> parameters, SessionStatus sessionStatus, Principal principal) {
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(parameters);
        if (authorizationRequest.getClientId() == null) {
            sessionStatus.setComplete();
            throw new InvalidClientException("A client_id must be supplied.");
        }
        if (!(principal instanceof Authentication) || !((Authentication)principal).isAuthenticated()) {
            sessionStatus.setComplete();
            throw new InsufficientAuthenticationException("User must be authenticated with Spring Security before authorization can be completed.");
        }
        Set<String> responseTypes = OAuth2Utils.parseParameterList(responseType);
        try {
            authorizationRequest = this.resolveRedirectUri(authorizationRequest);
            if (this.userApprovalHandler.isApproved(authorizationRequest, (Authentication)principal)) {
                if (responseTypes.contains("token")) {
                    return this.getImplicitGrantResponse(authorizationRequest.approved(true));
                }
                if (responseTypes.contains("code")) {
                    return new ModelAndView(this.getAuthorizationCodeResponse(authorizationRequest.approved(true), (Authentication)principal));
                }
                throw new UnsupportedGrantTypeException("Unsupported response type: " + responseTypes);
            }
            model.put("authorizationRequest", authorizationRequest);
            return this.getUserApprovalPageResponse(model, authorizationRequest);
        }
        catch (RuntimeException e) {
            sessionStatus.setComplete();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST})
    public View approveOrDeny(@RequestParam(value="user_oauth_approval") boolean approved, @ModelAttribute AuthorizationRequest authorizationRequest, SessionStatus sessionStatus, Principal principal) {
        if (authorizationRequest.getClientId() == null) {
            sessionStatus.setComplete();
            throw new InvalidClientException("A client_id must be supplied.");
        }
        if (!(principal instanceof Authentication)) {
            sessionStatus.setComplete();
            throw new InsufficientAuthenticationException("User must be authenticated with Spring Security before authorizing an access token.");
        }
        try {
            Set<String> responseTypes = authorizationRequest.getResponseTypes();
            authorizationRequest = this.resolveRedirectUri(authorizationRequest);
            if (responseTypes.contains("token")) {
                View view = this.getImplicitGrantResponse(authorizationRequest.approved(true)).getView();
                return view;
            }
            View view = this.getAuthorizationCodeResponse(authorizationRequest.approved(approved), (Authentication)principal);
            return view;
        }
        finally {
            sessionStatus.setComplete();
        }
    }

    private AuthorizationRequest resolveRedirectUri(AuthorizationRequest authorizationRequest) throws OAuth2Exception {
        String requestedRedirect = this.redirectResolver.resolveRedirect(authorizationRequest.getRedirectUri(), this.clientDetailsService.loadClientByClientId(authorizationRequest.getClientId()));
        return authorizationRequest.resolveRedirectUri(requestedRedirect);
    }

    private ModelAndView getUserApprovalPageResponse(Map<String, Object> model, AuthorizationRequest authorizationRequest) {
        this.logger.debug((Object)("Loading user approval page: " + this.userApprovalPage));
        model.putAll(authorizationRequest.getParameters());
        return new ModelAndView(this.userApprovalPage, model);
    }

    private ModelAndView getImplicitGrantResponse(AuthorizationRequest authorizationRequest) {
        try {
            OAuth2AccessToken accessToken = this.getTokenGranter().grant("implicit", authorizationRequest.getParameters(), authorizationRequest.getClientId(), authorizationRequest.getScope());
            if (accessToken == null) {
                throw new UnsupportedGrantTypeException("Unsupported grant type: implicit");
            }
            return new ModelAndView((View)new RedirectView(this.appendAccessToken(authorizationRequest, accessToken), false));
        }
        catch (OAuth2Exception e) {
            return new ModelAndView((View)new RedirectView(this.getUnsuccessfulRedirect(authorizationRequest, e), false));
        }
    }

    private View getAuthorizationCodeResponse(AuthorizationRequest authorizationRequest, Authentication authUser) {
        try {
            return new RedirectView(this.getSuccessfulRedirect(authorizationRequest, this.generateCode(authorizationRequest, authUser)), false);
        }
        catch (OAuth2Exception e) {
            return new RedirectView(this.getUnsuccessfulRedirect(authorizationRequest, e), false);
        }
    }

    private String appendAccessToken(AuthorizationRequest authorizationRequest, OAuth2AccessToken accessToken) {
        String requestedRedirect = authorizationRequest.getRedirectUri();
        if (accessToken == null) {
            throw new InvalidGrantException("An implicit grant could not be made");
        }
        StringBuilder url = new StringBuilder(requestedRedirect);
        if (requestedRedirect.contains("#")) {
            url.append("&");
        } else {
            url.append("#");
        }
        url.append("access_token=" + accessToken.getValue());
        url.append("&token_type=" + accessToken.getTokenType());
        Date expiration = accessToken.getExpiration();
        if (expiration != null) {
            long expires_in = (expiration.getTime() - System.currentTimeMillis()) / 1000L;
            url.append("&expires_in=" + expires_in);
        }
        return url.toString();
    }

    private String generateCode(AuthorizationRequest authorizationRequest, Authentication authentication) throws AuthenticationException {
        try {
            if (authorizationRequest.isDenied()) {
                throw new UserDeniedAuthorizationException("User denied authorization of the authorization code.");
            }
            if (!this.userApprovalHandler.isApproved(authorizationRequest, authentication)) {
                throw new UnapprovedClientAuthenticationException("The authorization hasn't been approved by the current user.");
            }
            AuthorizationRequestHolder combinedAuth = new AuthorizationRequestHolder(authorizationRequest, authentication);
            String code = this.authorizationCodeServices.createAuthorizationCode(combinedAuth);
            return code;
        }
        catch (OAuth2Exception e) {
            if (authorizationRequest.getState() != null) {
                e.addAdditionalInformation("state", authorizationRequest.getState());
            }
            throw e;
        }
    }

    private String getSuccessfulRedirect(AuthorizationRequest authorizationRequest, String authorizationCode) {
        if (authorizationCode == null) {
            throw new IllegalStateException("No authorization code found in the current request scope.");
        }
        String requestedRedirect = authorizationRequest.getRedirectUri();
        String state = authorizationRequest.getState();
        StringBuilder url = new StringBuilder(requestedRedirect);
        if (requestedRedirect.indexOf(63) < 0) {
            url.append('?');
        } else {
            url.append('&');
        }
        url.append("code=").append(authorizationCode);
        if (state != null) {
            url.append("&state=").append(state);
        }
        return url.toString();
    }

    private String getUnsuccessfulRedirect(AuthorizationRequest authorizationRequest, OAuth2Exception failure) {
        if (authorizationRequest == null || authorizationRequest.getRedirectUri() == null) {
            throw new UnapprovedClientAuthenticationException("Authorization failure, and no redirect URI.", (Throwable)((Object)failure));
        }
        String redirectUri = authorizationRequest.getRedirectUri();
        StringBuilder url = new StringBuilder(redirectUri);
        if (redirectUri.indexOf(63) < 0) {
            url.append('?');
        } else {
            url.append('&');
        }
        url.append("error=").append(failure.getOAuth2ErrorCode());
        url.append("&error_description=").append(failure.getMessage());
        if (failure.getAdditionalInformation() != null) {
            for (Map.Entry<String, String> additionalInfo : failure.getAdditionalInformation().entrySet()) {
                url.append('&').append(additionalInfo.getKey()).append('=').append(additionalInfo.getValue());
            }
        }
        return url.toString();
    }

    public void setUserApprovalPage(String userApprovalPage) {
        this.userApprovalPage = userApprovalPage;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setAuthorizationCodeServices(AuthorizationCodeServices authorizationCodeServices) {
        this.authorizationCodeServices = authorizationCodeServices;
    }

    public void setRedirectResolver(RedirectResolver redirectResolver) {
        this.redirectResolver = redirectResolver;
    }

    public void setUserApprovalHandler(UserApprovalHandler userApprovalHandler) {
        this.userApprovalHandler = userApprovalHandler;
    }

    @ExceptionHandler(value={HttpSessionRequiredException.class})
    public HttpEntity<String> handleException(HttpSessionRequiredException e, ServletWebRequest webRequest) throws Exception {
        return new ResponseEntity((Object)"Invalid state", HttpStatus.FORBIDDEN);
    }
}

