/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.code;

import java.util.Map;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientCredentialsChecker;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationRequestHolder;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationCodeTokenGranter
implements TokenGranter {
    private static final String GRANT_TYPE = "authorization_code";
    private final AuthorizationCodeServices authorizationCodeServices;
    private final ClientCredentialsChecker clientCredentialsChecker;
    private final AuthorizationServerTokenServices tokenServices;

    public AuthorizationCodeTokenGranter(AuthorizationServerTokenServices tokenServices, AuthorizationCodeServices authorizationCodeServices, ClientDetailsService clientDetailsService) {
        this.tokenServices = tokenServices;
        this.clientCredentialsChecker = new ClientCredentialsChecker(clientDetailsService);
        this.authorizationCodeServices = authorizationCodeServices;
    }

    @Override
    public OAuth2AccessToken grant(String grantType, Map<String, String> parameters, String clientId, Set<String> scopes) {
        if (!GRANT_TYPE.equals(grantType)) {
            return null;
        }
        String authorizationCode = parameters.get("code");
        String redirectUri = parameters.get("redirect_uri");
        if (authorizationCode == null) {
            throw new OAuth2Exception("An authorization code must be supplied.");
        }
        AuthorizationRequestHolder storedAuth = this.authorizationCodeServices.consumeAuthorizationCode(authorizationCode);
        if (storedAuth == null) {
            throw new InvalidGrantException("Invalid authorization code: " + authorizationCode);
        }
        AuthorizationRequest unconfirmedAuthorizationRequest = storedAuth.getAuthenticationRequest();
        if (unconfirmedAuthorizationRequest.getRedirectUri() != null && !unconfirmedAuthorizationRequest.getRedirectUri().equals(redirectUri)) {
            throw new RedirectMismatchException("Redirect URI mismatch.");
        }
        if (clientId != null && !clientId.equals(unconfirmedAuthorizationRequest.getClientId())) {
            throw new InvalidClientException("Client ID mismatch");
        }
        AuthorizationRequest authorizationRequest = this.clientCredentialsChecker.validateCredentials(grantType, clientId, unconfirmedAuthorizationRequest.getScope());
        if (authorizationRequest == null) {
            return null;
        }
        Authentication userAuth = storedAuth.getUserAuthentication();
        return this.tokenServices.createAccessToken(new OAuth2Authentication(authorizationRequest, userAuth));
    }
}

