/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.BaseClientDetails;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.util.Assert;

public class JdbcClientDetailsService
implements ClientDetailsService {
    private static final String DEFAULT_SELECT_STATEMENT = "select client_id, resource_ids, client_secret, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity from oauth_client_details where client_id = ?";
    private String selectClientDetailsSql = "select client_id, resource_ids, client_secret, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity from oauth_client_details where client_id = ?";
    private final JdbcTemplate jdbcTemplate;

    public JdbcClientDetailsService(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public ClientDetails loadClientByClientId(String clientId) throws OAuth2Exception {
        ClientDetails details;
        try {
            details = (ClientDetails)this.jdbcTemplate.queryForObject(this.selectClientDetailsSql, (RowMapper)new RowMapper<ClientDetails>(){

                public ClientDetails mapRow(ResultSet rs, int rowNum) throws SQLException {
                    BaseClientDetails details = new BaseClientDetails(rs.getString(2), rs.getString(4), rs.getString(5), rs.getString(7));
                    details.setClientId(rs.getString(1));
                    details.setClientSecret(rs.getString(3));
                    details.setRegisteredRedirectUri(rs.getString(6));
                    details.setAccessTokenValiditySeconds(rs.getInt(8));
                    return details;
                }
            }, new Object[]{clientId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new InvalidClientException("Client not found: " + clientId);
        }
        return details;
    }

    public void setSelectClientDetailsSql(String selectClientDetailsSql) {
        this.selectClientDetailsSql = selectClientDetailsSql;
    }
}

